#include "TIMER.h"

Timer timer;
Thread threadTimer;
Thread threadCalculateTime;
Semaphore semaphoreTimer(0, 1);
Semaphore semaphoreModify(0, 1);
Semaphore semaphoreModifyThread(0, 1);

static int realTime = 0;
static int additionalTime = 0;
static int zeroBaseTime = 0;
static int displayTime = 0;

int timerHour = 0;
int timerMinute = 0;
int timerSecond = 0;

int MODE_MODIFY_TIME = ABLE_TO_MODIFY_TIME;

static void _increaseHour(void)
{
    semaphoreTimer.acquire();
    additionalTime += 3600;
    semaphoreTimer.release();
}

static void _decreaseHour(void)
{
    semaphoreTimer.acquire();
    if(additionalTime >= 3600) {
        additionalTime -= 3600;
    } else {
        additionalTime += 82800;
    }
    semaphoreTimer.release();
}

static void _decreaseMinute(void)
{
    semaphoreTimer.acquire();
    if(additionalTime >= 60) {
        additionalTime -= 60;
    } else {
        additionalTime += 3540;
    }
    semaphoreTimer.release();
}
static void _increaseMinute(void)
{
    semaphoreTimer.acquire();
    additionalTime += 60;
    semaphoreTimer.release();
}

static void _clearTime(void)
{
    semaphoreTimer.acquire();
    zeroBaseTime = realTime % 60;
    semaphoreTimer.release();

}
static void _threadCalculateTime(void)
{
    while(1) {
        semaphoreModifyThread.acquire();
        switch(joystickDir()) {
            case JOYSTICK_U:
                _increaseHour();
                break;

            case JOYSTICK_D:
                _decreaseHour();
                break;

            case JOYSTICK_L:
                _decreaseMinute();
                break;

            case JOYSTICK_R:
                _increaseMinute();
                break;

            case JOYSTICK_C:
                _clearTime();
                break;
        }

        semaphoreModifyThread.release();
        while(joystickDir() != -1);
        thread_sleep_for(JOYSTICK_CLICK_DELAY);

    }
}


static void _threadTimer(void)
{
    while(1) {
        semaphoreTimer.acquire();
        realTime = timer.read() + additionalTime;
        displayTime = realTime - zeroBaseTime;

        timerHour = (displayTime / 3600) % 24;
        timerMinute = (displayTime % 3600) / 60;
        timerSecond = (displayTime) % 60;

        semaphoreTimer.release();
    }
}

// =============================================================================

void timerTerminateTimeModify(void)
{
    semaphoreModifyThread.acquire();
}

void timerStartTimeModify(void)
{
    semaphoreModifyThread.release();
}


void timerInit(void)
{
    timerHour = 0;
    timerMinute = 0;
    timerSecond = 0;

    timer.start();
    threadTimer.start(_threadTimer);
    MODE_MODIFY_TIME = ABLE_TO_MODIFY_TIME;
    threadCalculateTime.start(_threadCalculateTime);
    semaphoreTimer.release();
    semaphoreModify.release();
    semaphoreModifyThread.release();
}
