#include "SWITCH_APPLICATION.h"

Thread threadSwitches[2];

static void _threadSwitchLeft(void)
{
    while(1) {
        if(switchValueWait(SWITCH_LEFT) == 1) {
            semaphoreModify.acquire();
            if(MODE_MODIFY_TIME == ABLE_TO_MODIFY_TIME) {
                MODE_MODIFY_TIME = UNABLE_TO_MODIFY_TIME;
                semaphoreModify.release();
                applicationChangeMode();
            } else {
                MODE_MODIFY_TIME = ABLE_TO_MODIFY_TIME;
                semaphoreModify.release();
                applicationChangeMode();
            }

            while(switchValue(SWITCH_LEFT) == 1) {
                thread_sleep_for(SWITCH_DEBOUNCING_DELAY);
            }
        }
    }
}
static void _threadSwitchRight(void)
{
    while(1) {
        if(switchValueWait(SWITCH_RIGHT) == 1) {
            semaphoreAlarmData.acquire();
            if(alarmState == ALARM_ENABLED) {
                alarmState = ALARM_DISABLED;
                semaphoreAlarmData.release();
            } else {
                alarmState = ALARM_ENABLED;
                semaphoreAlarmData.release();
            }

            while(switchValue(SWITCH_RIGHT) == 1) {
                thread_sleep_for(SWITCH_DEBOUNCING_DELAY);
            }
        }
    }
}
void switchApplicationInit(void)
{
    threadSwitches[SWITCH_LEFT].start(_threadSwitchLeft);
    threadSwitches[SWITCH_RIGHT].start(_threadSwitchRight);
}