#include "SWITCH.h"

InterruptIn switch2(SW2);
InterruptIn switch3(SW3);

Semaphore semaphoreISRSwitchLeft(0, 1);
Semaphore semaphoreISRSwitchRight(0, 1);

static bool _switchData[2] = {0, 0};

static void _switchBeep()
{
    buzzerInstruction = BUZZER_INSTRUCTION_RINGING;
    buzzerDelay = SWITCH_DEBOUNCING_DELAY;
    buzzerCnt = SWITCH_BEEP_CNT;
    semaphoreBuzzerValues.release();
    semaphoreBuzzer.release();
}
static void _switchLeftPushed(void)
{
    _switchData[SWITCH_LEFT] = 1;
    if(semaphoreBuzzerValues.try_acquire() == true) {
        _switchBeep();
    }
    semaphoreISRSwitchLeft.release();
}
static void _switchRightPushed(void)
{
    _switchData[SWITCH_RIGHT] = 1;
    if(semaphoreBuzzerValues.try_acquire() == true) {
        _switchBeep();
    }
    semaphoreISRSwitchRight.release();
}

static void _switchLeftReleased(void)
{
    _switchData[SWITCH_LEFT] = 0;
    semaphoreISRSwitchLeft.release();
}

static void _switchRightReleased(void)
{
    _switchData[SWITCH_RIGHT] = 0;
    semaphoreISRSwitchRight.release();
}

// ====================================================================================

void switchInit(void)
{
    printf("Init switches\r\n");
    switch3.rise(_switchLeftReleased);
    switch2.rise(_switchRightReleased);
    switch3.fall(_switchLeftPushed);
    switch2.fall(_switchRightPushed);
}

bool switchValue(int dir)
{
    return _switchData[dir];
}

bool switchValueWait(int dir)
{
    if(dir == SWITCH_LEFT) {
        semaphoreISRSwitchLeft.acquire();
    } else {
        semaphoreISRSwitchRight.acquire();
    }
    printf("Switch%d read\r\n",dir);
    return _switchData[dir];
}