#include "POT.h"

AnalogIn    potL(A0);
AnalogIn    potR(A1);

static float _previousPotData[2] = {0, 0};

void potInit(void)
{
    printf("Init potentiometers\r\n");
    _previousPotData[POT_LEFT] = potL.read();
    _previousPotData[POT_RIGHT] = potR.read();
}

bool potIsChanged(int pot)
{
    AnalogIn *pPot;
    float currentPotData;
    bool result;

    switch(pot) {
        case POT_LEFT:
            pPot = &potL;
            break;
        case POT_RIGHT:
            pPot = &potR;
            break;
        default:
            pPot = &potL;
            break;
    }

    currentPotData = (*pPot).read();

    if(_previousPotData[pot] == currentPotData) {
        result = POT_UNCHANGED;
    } else {
        result = POT_CHANGED;
    }
    _previousPotData[pot] = currentPotData;

    return result;
}

float potValue(int pot)
{
    AnalogIn *pPot;

    switch(pot) {
        case POT_LEFT:
            pPot = &potL;
            break;
        case POT_RIGHT:
            pPot = &potR;
            break;
        default:
            pPot = &potL;
            break;
    }

    return (*pPot).read();
}

unsigned short potValueU16(int pot)
{
    AnalogIn *pPot;

    switch(pot) {
        case POT_LEFT:
            pPot = &potL;
            break;
        case POT_RIGHT:
            pPot = &potR;
            break;
        default:
            pPot = &potL;
            break;
    }

    return (*pPot).read_u16();
}