#include "LCD.h"

C12832  _lcd(D11, D13, D12, D7, D10);
Thread _lcdShowLoadingSimbol;
Semaphore semaphoreLCD(0, 1);
Semaphore semaphoreLCDLoading(0, 1);

int _x, _y;

static void lcdShowLoadingSimbol(void)
{
    unsigned int count = 0;
    char simbols[] = {'\\', '|', '/', '-'};
    while(1) {
        for(int i = 0; i < 4; i++) {
            semaphoreLCDLoading.acquire();
            semaphoreLCD.acquire();
            _lcd.locate(_x, _y);
            _lcd.putc(simbols[i]);
            semaphoreLCD.release();
            semaphoreLCDLoading.release();
            thread_sleep_for(LCD_LOADING_TERM);
        }
    }
}

void lcdInit(void)
{
    semaphoreLCD.release();
    _lcdShowLoadingSimbol.start(lcdShowLoadingSimbol);
}

void lcdShowLoadingSimbolStart(int x, int y)
{
    _x = x;
    _y = y;
    semaphoreLCDLoading.release();

}

void lcdShowLoadingSimbolTerminate(void)
{
    semaphoreLCDLoading.acquire();
}
