#include "JOYSTICK.h"

InterruptIn joystickU(A2);
InterruptIn joystickD(A3);
InterruptIn joystickL(A4);
InterruptIn joystickR(A5);
InterruptIn joystickC(D4);

static int _joystickDataForISR = -1;

static void _joystickBeep()
{
    buzzerInstruction = BUZZER_INSTRUCTION_RINGING;
    buzzerDelay = JOYSTICK_BEEP_DELAY;
    buzzerCnt = JOYSTICK_BEEP_CNT;
    semaphoreBuzzerValues.release();
    semaphoreBuzzer.release();
}

static void _joystickPushedU()
{
    if(semaphoreBuzzerValues.try_acquire() == true) {
        _joystickDataForISR = JOYSTICK_U;
        _joystickBeep();
    }
}
static void _joystickPushedD()
{
    if(semaphoreBuzzerValues.try_acquire() == true) {
        _joystickDataForISR = JOYSTICK_D;
        _joystickBeep();
    }
}
static void _joystickPushedL()
{
    if(semaphoreBuzzerValues.try_acquire() == true) {
        _joystickDataForISR = JOYSTICK_L;
        _joystickBeep();
    }

}
static void _joystickPushedR()
{
    if(semaphoreBuzzerValues.try_acquire() == true) {
        _joystickDataForISR = JOYSTICK_R;
        _joystickBeep();

    }
}
static void _joystickPushedC()
{
    if(semaphoreBuzzerValues.try_acquire() == true) {
        _joystickDataForISR = JOYSTICK_C;
        _joystickBeep();

    }
}
static void _joystickReleased(void)
{
    _joystickDataForISR = -1;
}


// ====================================================================================

void joystickInit(void)
{
    printf("Init joysticks\r\n");
    joystickU.rise(_joystickPushedU);
    joystickD.rise(_joystickPushedD);
    joystickL.rise(_joystickPushedL);
    joystickR.rise(_joystickPushedR);
    joystickC.rise(_joystickPushedC);

    joystickU.fall(_joystickReleased);
    joystickD.fall(_joystickReleased);
    joystickL.fall(_joystickReleased);
    joystickR.fall(_joystickReleased);
    joystickC.fall(_joystickReleased);
}


int joystickDir(void)
{
    return _joystickDataForISR;
}