#ifndef _BUZZER_H
#define _BUZZER_H

#include "mbed.h"
#include "pitches.h"

#define BUZZER_BEEP_FREQUENCY    NOTE_A5
#define BUZZER_PIN  D6

#define BUZZER_INSTRUCTION_INIT     0
#define BUZZER_INSTRUCTION_OFF      1
#define BUZZER_INSTRUCTION_ON       2
#define BUZZER_INSTRUCTION_RINGING  3

extern PwmOut buzzer;
extern char buzzerInstruction;
extern short buzzerCnt;
extern int buzzerDelay;

extern Semaphore semaphoreBuzzer;
extern Semaphore semaphoreBuzzerValues;

void buzzerInit(void);
void buzzerOn(void);
void buzzerOn(int freq);
void buzzerOff(void);
void buzzerRinging(short cnt, int delay);
void buzzerRinging(short cnt, int delay, int freq);

#endif