#include "BUZZER.h"

PwmOut buzzer(BUZZER_PIN);
Thread buzzerThread;

Semaphore semaphoreBuzzer(0);
Semaphore semaphoreBuzzerValues(1);

char buzzerInstruction = 0;
short buzzerCnt = 0;
int buzzerDelay = 0;
int buzzerFreq = BUZZER_BEEP_FREQUENCY;

static void _buzzerThread(void)
{
    int instruction;
    int delay;
    int cnt;
    int freq;
    while(1) {
        semaphoreBuzzer.acquire();
        semaphoreBuzzerValues.acquire();

        instruction = buzzerInstruction;
        delay = buzzerDelay;
        cnt = buzzerCnt;
        buzzerInstruction = BUZZER_INSTRUCTION_OFF;
        freq = buzzerFreq;

        semaphoreBuzzerValues.release();

        switch(instruction) {
            case BUZZER_INSTRUCTION_INIT:
                buzzer.period(1.0 / BUZZER_BEEP_FREQUENCY);
            case BUZZER_INSTRUCTION_OFF:
                buzzer = 0;
                break;

            case BUZZER_INSTRUCTION_ON:
                buzzer.period(1.0 / freq);
                buzzer = 0.5;
                break;

            case BUZZER_INSTRUCTION_RINGING:
                buzzer.period(1.0 / freq);
                for(cnt; cnt > 0; cnt--) {
                    buzzer = 0.5;
                    thread_sleep_for(delay);
                    buzzer = 0.0;
                    thread_sleep_for(delay);
                }
                break;
        }
    }
}

void buzzerInit(void)
{
    printf("Init buzzer\r\n");
    semaphoreBuzzerValues.acquire();
    buzzerInstruction = BUZZER_INSTRUCTION_INIT;
    buzzerCnt = 0;
    buzzerDelay = 0;
    semaphoreBuzzerValues.release();
    semaphoreBuzzer.release();
    buzzerThread.start(_buzzerThread);
}

void buzzerOn(int freq)
{
    semaphoreBuzzerValues.acquire();
    buzzerFreq = freq;
    buzzerInstruction = BUZZER_INSTRUCTION_ON;
    semaphoreBuzzerValues.release();
    semaphoreBuzzer.release();
}

void buzzerOn(void)
{
    semaphoreBuzzerValues.acquire();
    buzzerFreq = BUZZER_BEEP_FREQUENCY;
    buzzerInstruction = BUZZER_INSTRUCTION_ON;
    semaphoreBuzzerValues.release();
    semaphoreBuzzer.release();
}

void buzzerOff(void)
{
    semaphoreBuzzerValues.acquire();
    buzzerInstruction = BUZZER_INSTRUCTION_OFF;
    semaphoreBuzzerValues.release();
    semaphoreBuzzer.release();
}
void buzzerRinging(short cnt, int delay, int freq)
{
    semaphoreBuzzerValues.acquire();
    buzzerFreq = freq;
    buzzerInstruction = BUZZER_INSTRUCTION_RINGING;
    buzzerCnt = cnt;
    buzzerDelay = delay;
    semaphoreBuzzerValues.release();
    semaphoreBuzzer.release();
}

void buzzerRinging(short cnt, int delay)
{
    semaphoreBuzzerValues.acquire();
    buzzerFreq = BUZZER_BEEP_FREQUENCY;
    buzzerInstruction = BUZZER_INSTRUCTION_RINGING;
    buzzerCnt = cnt;
    buzzerDelay = delay;
    semaphoreBuzzerValues.release();
    semaphoreBuzzer.release();
}
