#include "APPLICATION.h"

Thread threadMode;
Semaphore semaphoreApplication(0, 1);

static void _threadMode(void)
{
    /*
        * 디바이스의 각종 모드를을 수정한 후, 적절한 동작을 취하게할 때 사용하는 쓰레드입니다.
        * 현재 디바이스에서는 MODE_MODIFY_TIME가 다른 모드로 변경되었을 때 호출되어 시간 수정을 가능ㅎ하게 할지 불가능하게 할지를 결정하게합니다.
    */
    while(1) {
        semaphoreApplication.acquire();
        semaphoreModify.acquire();
        if(MODE_MODIFY_TIME == ABLE_TO_MODIFY_TIME) {
            semaphoreModify.release();
            timerStartTimeModify();
        } else {
            semaphoreModify.release();
            timerTerminateTimeModify();
        }
    }
}

void applicationChangeMode(void)
{
    /*
        * 디바이스의 모드를 동기화할 때 호출되는 함수입니다.
        * 현재 디바이스에서는 MODE_MODIFY를 수정하고, _threadMode를 호출하여 동기화시키는 목적으로 사용됩니다.
    */
    semaphoreApplication.release();
}

void applicationInit(void)
{
    /*
        * 각종 디바이스의 장치들을 초기화하기 위한 함수입니다.
    */
    PC.baud(115200);
    buzzerInit();
    ledInit();
    switchInit();
    switchApplicationInit();
    potInit();
    joystickInit();
    wifiInit();
    lcdInit();
    alarmInit();
    threadMode.start(_threadMode);
}