#include "ALARM.h"

short alarmHour = 0;
short alarmMinute = 12;
short alarmSecond = 00;
bool alarmState = false;

Semaphore semaphoreAlarmData(0, 1);
Thread _threadAlarm[2];
void _alarmGetDataFromHTML(void)
{
    while(1) {
        semaphoreWifiHasBuffer.acquire();
        PC.printf("%s\r\n", wifiReceivedBuffer);
        alarmHour = 10 * (wifiReceivedBuffer[1] - '0') + (wifiReceivedBuffer[2] - '0');
        alarmMinute = 10 * (wifiReceivedBuffer[6] - '0') + (wifiReceivedBuffer[7] - '0');
        alarmSecond = 10 * (wifiReceivedBuffer[11] - '0') + (wifiReceivedBuffer[12] - '0');

        if((0 <= alarmHour && alarmHour < 24) &&
                (0 <= alarmMinute && alarmMinute < 60) &&
                (0 <= alarmSecond && alarmSecond < 60)) {
            alarmState = true;
        } else {
            alarmState = false;
        }
        semaphoreAlarmData.release();
        buzzerRinging(4, 50);
    }
}

void _alarmDoAlert(void)
{
    short _alarmHour, _timerHour;
    short _alarmMinute, _timerMinute;
    short _alarmSecond, _timerSecond;
    bool _alarmState;
    while(1) {
        semaphoreAlarmData.acquire();
        _alarmHour = alarmHour;
        _alarmMinute = alarmMinute;
        _alarmSecond = alarmSecond;
        _alarmState = alarmState;
        semaphoreAlarmData.release();

        semaphoreTimer.acquire();
        _timerHour = timerHour;
        _timerMinute = timerMinute;
        _timerSecond = timerSecond;
        semaphoreTimer.release();

        if(_alarmState == true) {
            if(_alarmHour == _timerHour) {
                if(_alarmMinute == _timerMinute) {
                    if(_alarmSecond == _timerSecond) {
                        bellSingleAlert(1000 * 30);
                    }
                }
            }
        }
    }
}

void alarmInit(void)
{
    _threadAlarm[0].start(_alarmGetDataFromHTML);
    _threadAlarm[1].start(_alarmDoAlert);
    semaphoreAlarmData.release();
}