//https://developer.mbed.org/users/pkozyra/code/HW_CRC_K64F/

#include "mbed.h"
#include "CRC_HW.h"

Timer tmr;
#define micros tmr.read_us

#define BUFSIZE 32768

FastCRC16 CRC16;

uint16_t crc_xmodem(uint16_t crc, uint8_t data);
uint16_t crc_xmodem(uint16_t polymian, uint16_t data);

uint16_t buf[BUFSIZE] ;


main() {
    uint32_t time;
    uint32_t crc;

  tmr.start();
  printf("\nSystemCoreClock %d %s %s\n",SystemCoreClock,__TIME__,__DATE__);
  
  uint16_t polymian = 0x1021;uint8_t data[] = {0x75};
  uint16_t data16[] = {0x75FA};
  uint16_t size = sizeof(data16);

  time = micros();
  crc = crc_xmodem(polymian,data16[0]);
  time = micros() - time;
  printf("Soft16bitCRC: crc: %x time: %d\n", crc, time);
 
  time = micros();
  crc = CRC16.xmodem(polymian, data16[0]);
  time = micros() - time;
  printf("Hard16bitCRC: crc: %x time: %d\n", crc, time); 

  printf("\nCRC Benchmark %d bytes\n",sizeof(buf));

  //Fill array with data
  for (int i=0; i<BUFSIZE; i++) {
    buf[i] = (i+1) & 0xffff;
  }

  time = micros();
  for (int i=0; i<BUFSIZE; i++) {
    crc = crc_xmodem(polymian, buf[i]);
  }
  time = micros() - time;
  printf("Soft16bitCRC: time: %dus\n", time);
  
  time = micros();
  for (int i=0; i<BUFSIZE; i++) {
    crc = CRC16.xmodem(polymian, buf[i]);
  }
  time = micros() - time;
  printf("Hard16bitCRC: time: %dus\n", time); 
  
  
}

uint16_t crc_xmodem(uint16_t polymian, uint8_t data)
{
    unsigned int i;
    uint16_t crc = 0x0000;
    crc = crc ^ ((uint16_t)data << 8);
    for (i=0; i<8; i++) {
        if (crc & 0x8000) {
            crc = (crc << 1) ^ polymian;
        } else {
            crc <<= 1;
        }
    }
    return crc;
}

uint16_t crc_xmodem(uint16_t polymian, uint16_t data)
{
    unsigned int i;
    uint16_t crc = 0x0000;
    crc = crc ^ data;
    for (i=0; i<16; i++) {
        if (crc & 0x8000) {
            crc = (crc << 1) ^ polymian;
        } else {
            crc <<= 1;
        }
    }
    return crc;
}
