
#if !defined(CRC_HW_h)
#define CRC_HW__h
#include "inttypes.h"
#include "mbed.h"

// ================= DEFINES ===================
#define CRC_FLAG_OFF               (((1<<31) | (1<<30)) | ((0<<29) | (0<<28))) //refin=false refout=false
#define CRC_FLAG_TOT00_TOTR00      (((0<<31) | (0<<30)) | ((0<<29) | (0<<28))) //refin=false refout=true
#define CRC_FLAG_TOT00_TOTR11      (((0<<31) | (0<<30)) | ((1<<29) | (1<<28))) //refin=false refout=true
#define CRC_FLAG_TOT11_TOTR00      (((1<<31) | (1<<30)) | ((0<<29) | (0<<28))) //refin=false refout=false
#define CRC_FLAG_TOT11_TOTR11      (((1<<31) | (1<<30)) | ((1<<29) | (1<<28))) //refin=true refout=true
#define CRC_FLAG_XOR               (1<<26)                                     //Perform XOR on result


// ================= 16-BIT CRC ===================

class FastCRC16
{
public:
  FastCRC16();
  uint16_t xmodem(uint16_t poly, uint16_t data);
  uint16_t generic(const uint16_t polynom, const uint16_t seed, const uint32_t flags, uint16_t data);

private:
  uint16_t seed;
  uint16_t update(uint16_t data);

};

// ================= 32-BIT CRC ===================

class FastCRC32
{
public:
  FastCRC32();
  uint32_t crc32(const uint8_t *data, const uint16_t datalen);      
  uint32_t generic(const uint32_t polyom, const uint32_t seed, const uint32_t flags, const uint8_t *data, const uint16_t datalen); 

private:
  uint32_t seed;
  uint32_t update(const uint8_t *data, const uint16_t datalen);
};

#endif