#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "Speaker.h"
#include <wave_player.h>
#include <string>

uLCD_4DGL uLCD(p28, p27, p29); // create a global lcd object
Serial  pc(USBTX, USBRX);
RawSerial  bluemod(p13,p14);
Mutex uLCDmutex;
PwmOut blue(p23);
PwmOut green(p22);
PwmOut red(p21);
Thread t1;
Thread t2;
Thread t3;

Speaker mySpeaker(p25);

void threat1RGB()
{
    char bred=0;
    char bgreen=0;
    char bblue=0;
    red = green = blue = 0;
    while(1) {
        if(bluemod.readable()) {
            uLCDmutex.lock();
            if (bluemod.getc()=='!') {
                if (bluemod.getc()=='C') { //color data packet
                    printf("Color Packet Recieved\r\n");
                    bred = bluemod.getc(); // RGB color values
                    bgreen = bluemod.getc();
                    bblue = bluemod.getc();
                    if (bluemod.getc()==char(~('!' + 'C' + bred + bgreen + bblue))) { //checksum OK?
                        printf("valid checksum, LED changing\r\n");
                        red = bred/255.0; //send new color to RGB LED PWM outputs
                        green = bgreen/255.0;
                        blue = bblue/255.0;
                    }
                }
            }
            uLCDmutex.unlock();
            Thread::wait(500);
        }
    }
}

void thread2image()
{
    while(1) {
        while(bluemod.readable()) {
            uLCDmutex.lock();
            if(bluemod.getc() == '1') {
                printf("Image Displaying\r\n");
                uLCD.media_init();
                uLCD.set_sector_address(0x0000, 0x0000);
                uLCD.display_image(0,0);
            } else if(bluemod.getc() == '2') {
                printf("Clear Screen\r\n");
                uLCD.cls();
            }
            uLCDmutex.unlock();
            Thread::wait(500);
        }
    }
}

void thread3Audio()
{
    float D41 = 293.665;
    float Eb4 = 311.127;
    float F4 = 349.228;
    float G4 = 391.995;
    float len = 0.40;
    float note[18]= {G4, F4, Eb4, Eb4, Eb4, F4, G4, G4, G4, F4, Eb4, F4, G4, F4, Eb4, D41, Eb4, 0.0};
    float dur[18]= {len, 0.5*len, len, 0.5*len, len, 0.5*len, len, len, 0.5*len, 0.5*len, 0.5*len, 0.5*len, 0.5*len,0.5*len, 1*len, 0.5*len, 1.5*len, 0.0};
    int playFlag = 0;

    while(1) {
        while(bluemod.readable()) {
            uLCDmutex.lock();
            if(bluemod.getc() == '3') {
                printf("Playing Audio\r\n");
                playFlag = 1;
            }
            uLCDmutex.unlock();
            if(playFlag == 1) {
                for(int i = 0; i < 18; ++i) {
                    mySpeaker.PlayNote(note[i],dur[i],0.5);
                }
                playFlag = 0;
            }
            Thread::wait(500);
        }
    }
}

int main()
{
    uLCD.cls();
    uLCD.baudrate(3000000); //jack up baud rate to max for fast display
    t1.start(threat1RGB);
    t2.start(thread2image);
    t3.start(thread3Audio);
    set_time(0);  // Set RTC time to 0
    char buffer[32];
    while(1) {
        time_t seconds = time(NULL);
        strftime(buffer, 32, "%M:%S", localtime(&seconds));
        uLCDmutex.lock();
        uLCD.locate(0,0);
        uLCD.text_width(2); //2X size text
        uLCD.text_height(2);
        uLCD.printf("UP: %s", buffer);
        uLCDmutex.unlock();
        Thread::wait(500);
    }
}
