#include "mbed.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include "Speaker.h"
#include <string>
#include <cstdlib>
#include <ctime>
#include <vector>
#include <iterator>
#include <algorithm>

#define SHIP_HEIGHT 4
#define SHIP_WIDTH 15
#define ALIEN_HEIGHT 8
#define ALIEN_WIDTH 11

#define _ 0x000000 // BLACK
#define X 0xFFFFFF // WHITE
#define Y 0x0000FF  // Blue
using namespace std;
uLCD_4DGL uLCD(p28, p27, p29);
Speaker mySpeaker(p21);
PinDetect left(p17);
PinDetect shoot(p18);
PinDetect right(p16);
Timer timer; // For measuring Elapsed time

static int shipx = 57;
static int shipy = 120;
static int bulletx = 65;
static int bullety = 115;
static bool movement = false;
static bool direction = false;
static bool fire = false;
int clear[8*11] = {
    Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,
    Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,
    Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,
    Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,
    Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,
    Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,
    Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,
    Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y
};

int alienAli_sprite[ALIEN_HEIGHT * ALIEN_WIDTH] = {
    X,X,X,_,_,_,_,_,X,X,X,
    X,X,X,_,_,_,_,X,X,X,_,
    X,X,X,_,_,X,X,X,_,_,_,
    X,X,X,X,X,X,_,_,_,_,_,
    X,X,X,X,X,X,X,_,_,_,_,
    X,X,X,_,_,X,X,X,_,_,_,
    X,X,X,_,_,_,_,X,X,X,_,
    X,X,X,_,_,_,_,_,X,X,X
};
int alienAlice_sprite[ALIEN_HEIGHT * ALIEN_WIDTH] = {
    _,_,_,_,X,X,X,_,_,_,_,
    _,X,X,X,X,X,X,X,X,X,_,
    X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,_,_,X,_,_,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,
    _,_,_,X,X,_,X,X,_,_,_,
    _,_,X,X,_,_,_,X,X,_,_,
    X,X,_,_,_,X,_,_,_,X,X
};
int alienBobDown_sprite[ALIEN_HEIGHT * ALIEN_WIDTH] = {
    _,_,X,_,_,_,_,_,X,_,_,
    _,_,_,X,_,_,_,X,_,_,_,
    _,_,X,X,X,X,X,X,X,_,_,
    _,X,X,_,X,X,X,_,X,X,_,
    X,X,X,X,X,X,X,X,X,X,X,
    X,_,X,X,X,X,X,X,X,_,X,
    X,_,X,_,_,_,_,_,X,_,X,
    _,_,_,X,X,_,X,X,_,_,_
};

int alienBobUp_sprite[ALIEN_HEIGHT * ALIEN_WIDTH] = {
    _,_,X,_,_,_,_,_,X,_,_,
    X,_,_,X,_,_,_,X,_,_,X,
    X,_,X,X,X,X,X,X,X,_,X,
    X,X,X,_,X,X,X,_,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,
    _,_,X,X,X,X,X,X,X,_,_,
    _,_,X,_,_,_,_,_,X,_,_,
    _,X,_,_,_,_,_,_,_,X,_
};

// Base Class
class ScreenAliens
{
public:
    ScreenAliens(string, int, int);

    virtual void draw() = 0;
    virtual void update() = 0;

    void setName(string);
    void setxPos(int);
    void setyPos(int);
    void setDir(int);

    string getName();
    int getxPos();
    int getyPos();
    int getDir();
private:

    string name;
    int xPos;
    int yPos;
    int dir;
};

ScreenAliens::ScreenAliens(string name, int xPos, int yPos)
{
    setName(name);
    setxPos(xPos);
    setyPos(yPos);
    srand(time(NULL));
    int status = rand()%2;
    setDir(status);
}

void ScreenAliens::setName(string name)
{
    this -> name = name;
}

void ScreenAliens::setxPos(int xPos)
{
    this -> xPos = xPos;
}

void ScreenAliens::setyPos(int yPos)
{
    this -> yPos = yPos;
}

void ScreenAliens::setDir(int dir)
{
    this -> dir = dir;
}

string ScreenAliens::getName()
{
    return name;
}

int ScreenAliens::getxPos()
{
    return xPos;
}

int ScreenAliens::getyPos()
{
    return yPos;
}

int ScreenAliens::getDir()
{
    return dir;
}


// Derived class AlienBob
class AlienBob:public ScreenAliens
{

public:
    AlienBob(int xPos, int yPos):ScreenAliens("AlienBob", xPos, yPos) {
        int status;
        srand(time(NULL));
        status = rand()%2;
        setUpDown(status);
    }

    void setUpDown(int upDown) {
        this -> upDown = upDown;
    }

    int getUpDown() {
        return upDown;
    }

    virtual void draw() {
        if (getUpDown() == 0) {
            uLCD.BLIT(ScreenAliens::getxPos(),ScreenAliens::getyPos(), ALIEN_WIDTH, ALIEN_HEIGHT, alienBobDown_sprite);
            setUpDown(1);
        } else {
            uLCD.BLIT(ScreenAliens::getxPos(),ScreenAliens::getyPos(), ALIEN_WIDTH, ALIEN_HEIGHT, alienBobUp_sprite);
            setUpDown(0);
        }
    }

    virtual void update() {
        uLCD.BLIT(ScreenAliens::getxPos(),ScreenAliens::getyPos(), ALIEN_WIDTH,ALIEN_HEIGHT, clear);
        if (ScreenAliens::getDir() == 0) {
            if (ScreenAliens::getxPos() - 5 <= 0 ) {
                ScreenAliens::setDir(1);
                ScreenAliens::setxPos(ScreenAliens::getxPos() + 5);
            } else {
                ScreenAliens::setxPos(ScreenAliens::getxPos() - 5);
            }
            draw();
        } else {
            if (ScreenAliens::getxPos() + 5 + ALIEN_WIDTH >= 128) {
                ScreenAliens::setDir(0);
                ScreenAliens::setxPos(ScreenAliens::getxPos() - 5);
            } else {
                ScreenAliens::setxPos(ScreenAliens::getxPos() + 5);
            }
            draw();
        }
    }
private:
    int upDown;
};

class AlienAlice:public ScreenAliens
{

public:
    AlienAlice(int xPos, int yPos):ScreenAliens("AlienAlice", xPos, yPos) {}

    virtual void draw() {
        uLCD.BLIT(ScreenAliens::getxPos(),ScreenAliens::getyPos(), ALIEN_WIDTH, ALIEN_HEIGHT, alienAlice_sprite);
    }

    virtual void update() {
        uLCD.BLIT(ScreenAliens::getxPos(),ScreenAliens::getyPos(), ALIEN_WIDTH,ALIEN_HEIGHT, clear);
        if (ScreenAliens::getDir() == 0) {
            if (ScreenAliens::getxPos() - 8 <= 0 ) {
                ScreenAliens::setDir(1);
                ScreenAliens::setxPos(ScreenAliens::getxPos() + 8);
            } else {
                ScreenAliens::setxPos(ScreenAliens::getxPos() - 8);
            }
            draw();
        } else {
            if (ScreenAliens::getxPos() + 8 + ALIEN_WIDTH >= 128) {
                ScreenAliens::setDir(0);
                ScreenAliens::setxPos(ScreenAliens::getxPos() - 8);
            } else {
                ScreenAliens::setxPos(ScreenAliens::getxPos() + 8);
            }
            draw();
        }
    }
};

class AlienAli:public ScreenAliens
{

public:

    AlienAli(int xPos, int yPos):ScreenAliens("AlienAli", xPos, yPos) {}

    virtual void draw() {
        uLCD.BLIT(ScreenAliens::getxPos(),ScreenAliens::getyPos(), ALIEN_WIDTH, ALIEN_HEIGHT, alienAli_sprite);
    }

    virtual void update() {
        uLCD.BLIT(ScreenAliens::getxPos(),ScreenAliens::getyPos(), ALIEN_WIDTH,ALIEN_HEIGHT, clear);
        if (ScreenAliens::getDir() == 0) {
            if (ScreenAliens::getxPos() - 10 <= 0 ) {
                ScreenAliens::setDir(1);
                ScreenAliens::setxPos(ScreenAliens::getxPos() + 10);
            } else {
                ScreenAliens::setxPos(ScreenAliens::getxPos() - 10);
            }
            draw();
        } else {
            if (ScreenAliens::getxPos() + 10 + ALIEN_WIDTH >= 128) {
                ScreenAliens::setDir(0);
                ScreenAliens::setxPos(ScreenAliens::getxPos() - 10);
            } else {
                ScreenAliens::setxPos(ScreenAliens::getxPos() + 10);
            }
            draw();
        }
    }
};


vector <ScreenAliens*> aliens(6);

//Code for the function of the pushbuttons
void left_hit_callback(void)
{
    movement = true;
    direction = false;
}

void right_hit_callback (void)
{
    movement = true;
    direction = true;
}

void shoot_hit_callback (void)
{
    if (!fire) {
        bulletx = shipx + 8;
    }
    fire = true;
}
void start()
{

    srand(time(0));
    int randomNum[6];
    int xpos[6];
    for (int i = 0; i < aliens.size(); i++) {
        randomNum[i] = rand()%3 + 1;
        xpos[i] = rand()%117 + 1;
    }

    for (int i = 0; i < 6; i++) {
        if (randomNum[i] == 1) {
            aliens[i] = new AlienBob(xpos[i], i*10 + 10);
        } else if (randomNum[i] == 2) {
            aliens[i] = new AlienAlice(xpos[i], i*10 + 10);
        } else if (randomNum[i] == 3) {
            aliens[i] = new AlienAli(xpos[i], i*10 + 10);
        }
    }

    aliens[0] -> draw();
    aliens[1] -> draw();
    aliens[2] -> draw();
    aliens[3] -> draw();
    aliens[4] -> draw();
    aliens[5] -> draw();

    uLCD.filled_rectangle(shipx,shipy,shipx+SHIP_WIDTH,shipy+SHIP_HEIGHT, X);
}

int main()
{
    uLCD.background_color(BLUE);     // Background color blue

    left.mode(PullUp);
    right.mode(PullUp);
    shoot.mode(PullUp);

    uLCD.printf("\n\nLAME Attack Game!");  // Welcome message
    wait(2.0);                      //1 pause system for 2.0
    uLCD.cls();                     // clear screen


    // Setup Interrupt callback functions for a pb hit
    left.attach_deasserted(&left_hit_callback);
    right.attach_deasserted(&right_hit_callback);
    shoot.attach_deasserted(&shoot_hit_callback);

    // Start sampling pb inputs using interrupts
    left.setSampleFrequency();
    right.setSampleFrequency();
    shoot.setSampleFrequency();
    start();
    timer.start();              // Starting timer to keep track how much time taken
    int startT = timer.read_ms();
    while (aliens.size() > 0) {

        for (int i = 0; i < aliens.size(); i++) {
            aliens[i] -> update();
        }
        if (fire) {
            uLCD.filled_rectangle(bulletx, bullety, bulletx + 2, bullety +4, Y);
            for (int i = 0; i < aliens.size(); i++) {
                if (((*aliens[i]).getxPos()- 4 <= bulletx) && (bulletx + 2 <= (*aliens[i]).getxPos() + ALIEN_WIDTH + 4)
                        && ((*aliens[i]).getyPos()- 8 <= bullety) && ((*aliens[i]).getyPos()+8 >= bullety - ALIEN_HEIGHT )) {
                    uLCD.BLIT((*aliens[i]).getxPos(),(*aliens[i]).getyPos(), ALIEN_WIDTH,ALIEN_HEIGHT, clear);
                    fire = false;
                    bullety = 115;
                    aliens.erase(aliens.begin()+i);
                    mySpeaker.PlayNote(100.0, 0.25, 0.01);
                } else if (bullety < 0) {
                    fire = false;
                    bullety = 115;
                }
            }
            if (fire) {
                bullety = bullety - 8;
                uLCD.filled_rectangle(bulletx, bullety, bulletx + 2, bullety + 4, RED);
            }
        }
        if (movement) {
            uLCD.filled_rectangle(shipx,shipy,shipx+SHIP_WIDTH,shipy+SHIP_HEIGHT,Y);
            if (direction) {
                if (shipx + SHIP_WIDTH + ALIEN_WIDTH > 128) {
                    shipx = 128-SHIP_WIDTH;
                } else {
                    shipx = shipx + ALIEN_WIDTH;
                }
            } else {
                if (shipx - ALIEN_WIDTH < 0) {
                    shipx = 0;
                } else {
                    shipx = shipx - ALIEN_WIDTH;
                }
            }
            movement = false;
            uLCD.filled_rectangle(shipx, shipy, shipx+SHIP_WIDTH,shipy+SHIP_HEIGHT,X);
        }
    }
    wait(1.0);
    mySpeaker.PlayNote(800.0, 1.0, 0.25);
    int endT = timer.read_ms();
    timer.stop();               // End of timer
    int total = (endT - startT)/1000;
    uLCD.cls();
    uLCD.printf("Earth Saved!\n\n%d seconds.", total);
}