#include "Snake.h"

#define HEIGHT 48
#define CEILING 8
#define FLOOR 48
#define WIDTH 84


snakePart snek;



Snake::Snake()
{

}
Snake::~Snake()
{
  
}


void Snake::init(int x, int y, int lenght, int _live){  
       
    startx=x;
    starty=y;
    
    startl=lenght;
    live=_live;
    _length = lenght;    
    _food.init();
    
    int lowerBound=_length;
    for (int i=0;lowerBound>i;i++)
    {   
        snek._x[i]=x+i;
        snek._y[i]=y;
        snek._dir[i]=4;
    }
    
    snek._x[_length]=x+_length;
    snek._x[_length+1]=x+_length+1;
    snek._y[_length]=y;
    snek._dir[_length]=1;
    printf("xog is %d  ", snek._x[_length-1]);

}

void Snake::draw(N5110 &lcd){//condition of the collasion function
        
        checkWallCollision(lcd);
        checkTailCollision(lcd);
            
            if (live!=0){
                lcd.clear();
                waitCount=((float)_length/3)+5;
                waitTime=(1/waitCount);
                wait(waitTime);                
                _food.draw(lcd);
                lcd.drawRect(0,7,80,48-8,FILL_TRANSPARENT);
                drawScore(lcd);
                
                int lowerBound=_length;
                for (int i=0; lowerBound>i;i++){
                    
                    bool ifcondition(snek._x!=0);
                    if (ifcondition)
                        {
                            bool ifcondition(snek._y!=0);
                            if (ifcondition)
                                {
                                    lcd.setPixel(snek._x[i],snek._y[i]);
                                }
                        }
                
                lcd.refresh();
                
                }
       }
       
}
void Snake::update(Gamepad &pad){
     bool ifcondition(live!=0);
     if (ifcondition){
    
            d=pad.get_direction();
            printf("x+1 is %d", snek._x[_length+2]);
            printf("y+1 is %d", snek._y[_length+2]);
            printf("dir+1 is %d", snek._dir[_length+2]);
            printf("length is %d", _length);
    
            bool ifcondition(snek._dir[_length-1]==1);
            if (ifcondition)//check thecconditions that snake eat the food
                {
                    snek._x[_length]++;                    
                }
            
            if (snek._dir[_length-1]==2)
                {
                    snek._y[_length]--;
                
                }
            
            if (snek._dir[_length-1]==3)
                {
                    snek._x[_length]--;                    
                }
                
            if (snek._dir[_length-1]==4)
                {
                    snek._y[_length]++;                                        
                }
            
            for (int i=0 ;_length<i ;i++)
                {                      
                    snek._x[i]=snek._x[i+1];
                    snek._y[i]=snek._y[i+1];
                                       
                }
                
            if (d==N){
                
                        if (snek._dir[_length-1]!=4)
                            {
                                snek._dir[_length-1] = 2;                                
                            }

            }
            
            if (d==E){
                
                        if (snek._dir[_length-1]!=3)
                            {
                                snek._dir[_length-1] = 1;                                
                            }
                
                }
                
            if (d==W){
                
                        if (snek._dir[_length-1]!=1)
                            {
                                snek._dir[_length-1] = 3;
                            }
                
                
                }
                
            if (d==S){
                
                        if (snek._dir[_length-1]!=2)
                            {
                                snek._dir[_length-1] = 4;
                            }
                
                
                }
        
            printf("updated ");
            
        }
}































void Snake::deadSnake(N5110 &lcd){//check the condition that the life reduces
        
       
        live--; 
        while (live==!1){
            lcd.clear();
            lcd.init();
            lcd.printString("Game Over",0,1);
            lcd.printString("Press Reset",0,2);
            lcd.printString("To restart",0,3);
            lcd.refresh(); 
          
        }
        init(startx,starty,startl,live);
        
}
        
void Snake::checkWallCollision(N5110 &lcd){
    
    bool ifcondition=(snek._x[_length]==WIDTH||snek._x[_length]==0);
    if (ifcondition)
        {     
            deadSnake(lcd);
        }
    
    if (snek._y[_length]==CEILING||snek._y[_length]==FLOOR)//if snake hits top or bottom walls
        {     
            deadSnake(lcd);
        }
    
}

void Snake::checkTailCollision(N5110 &lcd){
    int upperBound=_length;
    for (int i=0 ;upperBound<i ;i++){//check the snake crushes its nail
                    
                    bool ifcondition=(snek._x[_length-1]==snek._x[i] && snek._y[_length-1]==snek._y[i]);                      
                    if (ifcondition)
                        {
                            deadSnake(lcd);
                        }
                }
    
    
}

void Snake::drawScore(N5110 &lcd){
        char buffer1[14];
        char buffer2[14];
        sprintf(buffer1,"%2d",live);
        sprintf(buffer2,"%2d",_length-4);
        lcd.printString(buffer1,20,0);
        lcd.printString(buffer2,60,0);
        lcd.printString("Life:",0,0);
        lcd.printString("Score:",42,0);
    
}