// wifi8266 Static page WEB server to control Mbed

#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "time.h"
#include "wave_player.h"

Serial pc(USBTX, USBRX);
Serial wifi(p13, p14); // tx, rx for WiFi module

RawSerial  blue(p9,p10); //tx, rx for Bluetooth Module

Timer t1; //game timer
float time_score = 0.0;

//SoundEffects

//Speaker
PwmOut Speaker(p26);

AnalogOut DACout(p18);
//wave player plays a *.wav file to D/A and a PWM
wave_player waver(&DACout,&Speaker);

FILE* fp;

//SD
SDFileSystem sd(p5, p6, p7, p8, "sd");

//uLCD
uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;

// Standard Mbed LED definitions
DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
DigitalOut  led3(LED3);
DigitalOut  led4(LED4);


char btIn[16]; //input char array from bluetooth adapter


//things for drawing on uLCD
void draw_field();
void title_screen();
void next_round();
void game_over();
void draw_object(int , int );
int num_circles;
int num_squares;
int num_triangles;


void blue_recv(); //interrupt function for bluetooth connection

int update = 1;

int bt_int_val = -1;

bool alive = true;
int score = 0;
int round_ms = 7000;

int main()
{
    Speaker.period(1.0/8000.0);
    pc.baud(9600);
    blue.baud(9600);
    
    led1=1,led2=0,led3=0, led4=0;
    
    // Setup a serial interrupt to receive data from Bluetooth
    blue.attach(&blue_recv, Serial::RxIrq);
    
    
    title_screen();
    
    //game loop
    while(alive) {
        t1.start();
        draw_field(); //draw objects on screen
        bt_int_val = -1;
        while(t1.read_ms() < round_ms) { //5000ms to guess
            if (bt_int_val == num_triangles) {
                pc.printf("%d %d\n\r", bt_int_val, num_triangles);
                score++; //increase score
                if (round_ms >= 1000)
                    round_ms -= 500;
                next_round(); //print next_round screen
                t1.reset(); 
                break;
            } else if (bt_int_val != -1) {
                alive = false;
                break;
            }
        }
        if (t1.read_ms() >= round_ms) {
            alive = false;
            break;   
        }   
    }
    
    game_over();
    
    

}


//GRAPHICS 
//
////////

//plays sound, makes title screen, clears at end
void title_screen() {
    fp = fopen("/sd/mydir/title.wav", "r");
    uLCD.media_init();
    uLCD.set_sector_address(0x0000, 0x0000);
    uLCD.display_image(0,0);
    waver.play(fp);
    wait(2);
    fclose(fp);
    uLCD.cls();
    uLCD.media_init();
    uLCD.set_sector_address(0x0000, 0x0041);
    uLCD.display_image(0,0);
    wait(2);
    uLCD.cls();
}


//plays sound, makes next round, clears at end
void next_round() {
    fp = fopen("/sd/mydir/next.wav", "r");
    uLCD.cls();
    uLCD.printf("Good Job! \n There were \n%d triangles! \n Score: %d \n", num_triangles, score);
    uLCD.printf("You'll have \n%d ms \nfor the next one", round_ms);
    waver.play(fp);
    fclose(fp); 
    wait(3);
    uLCD.cls();
}

//plays sound, makes title screen, clears at end
void game_over() {
    uLCD.media_init();
    fp = fopen("/sd/mydir/gameover.wav", "r");
    uLCD.set_sector_address(0x0000, 0x0082);
    uLCD.display_image(0,0);
    waver.play(fp);
    fclose(fp);  
    uLCD.cls();
    uLCD.color(RED);
    uLCD.printf("There were %d \ntriangles! :(\n", num_triangles);
    uLCD.printf("Final Score: %d", score); 
    wait(3);
    uLCD.cls();
}
//draws a random object(color and shape) at a specific location
void draw_object(int xpos, int ypos) {
    xpos = xpos + 10;
    ypos = ypos + 10; //center the location of the drawn object in the grid
    int size = (rand() % 8) + 2; //range from 2 to 9 inclusive 
    int color = (rand() % 0x999999) + 0x555555;
    int shape = rand() % 100;
    int fill = rand() % 2;
    if(shape < 33) {
        uLCD.filled_circle(xpos, ypos, size, color);
        num_circles++;
    }
    else if (shape < 66) {
        uLCD.filled_rectangle(xpos - size, ypos - size, xpos+ size, ypos + size, color);
        num_squares++;
    }
    else {
        uLCD.triangle(xpos-size, ypos+size , xpos+size, ypos+size, xpos, ypos-size, color);
        num_triangles++;
    }
}

//draws and populates a box with objects
void draw_field() {
    num_circles = 0;
    num_triangles = 0;
    num_squares = 0;
    uLCD.cls();
    int start_x = 0;
    //draws rectangle
    uLCD.rectangle(start_x, 0, start_x+120,120, WHITE);
    
    //locates objects in box
    //for (int l = 0; l < 36; l++){
        for (int j = start_x; j < start_x+120; j += 20) {
            for(int i = 0; i < 120; i += 20) {
                draw_object(j, i);
            }
        }
    //}
    
}


////BLUETOOTH
//
////////

//receives int from BT controller
void blue_recv()
{
    char ch;
    int index = 0;
    do
    { 
       if (blue.readable())      // if there is an character to read from the device
       {
           ch = blue.getc();   // read it
          if (index<16)               // just to avoid buffer overflow
             btIn[index++]=ch;  // put it into the value array and increment the index
      }
    } while (ch!='\n');    // loop until the '\n' character
     
    btIn[index]='\x0';  // add un 0 to end the c string
    bt_int_val = atoi(btIn);
    update = 1;
    pc.printf("%d", bt_int_val);
}

