#include "mbed.h"
#include "motor_de_passo.h"

const int Motor_de_passo::motor[] =   {0x8,0xC,0x4,0x6,0x2,0x3,0x1,0x9};
Motor_de_passo::Motor_de_passo(PinName pino1, PinName pino2, PinName pino3, PinName pino4)
     : _passos(pino1,pino2,pino3,pino4)
     {
        // motor[] 
    }

void Motor_de_passo::motor1(){
   if (aux == 0){
        _passos = 0x0f&motor[1];
        aux = positivo?1:7;
    } else if (aux == 1){
        _passos = 0x0f&motor[2];
        aux = positivo?2:0;
    } else if (aux == 2){
        _passos = 0x0f&motor[3];
        aux = positivo?3:1;
    } else if (aux == 3){
        _passos = 0x0f&motor[4];
        aux = positivo?4:2;
    }else if (aux == 4){
        _passos = 0x0f&motor[5];
        aux = positivo?5:3;
    } else if (aux == 5){
        _passos = 0x0f&motor[6];
        aux = positivo?6:4;
    } else if (aux == 6){
        _passos = 0x0f&motor[7];
        aux = positivo?7:5;
    } else if (aux == 7){
        _passos = 0x0f&motor[0];
        aux = positivo?0:6;
                     
    }
 }
 
 void Motor_de_passo::flip() {
    motor1();
    i=i+1; 
    if (j==i){
           flipper.detach();
        }
}

void Motor_de_passo::girar (float graus) 
     {
        aux=0;
        positivo = graus<0? false: true;
        i=0;
        float tempo = (1.0f/((n_passos)*(vel)));
        flipper.attach(this,&Motor_de_passo::flip, tempo);
       
       j=abs(graus)/(360.0f/n_passos);
       
     }
