#include "mbed.h"
#include "FM_Radio.h"

#include "mbed.h"
#include "FM_Radio.h"
#include "device.h"
#include "MFRC522.h"
 //KL25Z Pins for MFRC522 SPI interface
 #define SPI_MOSI    p5
 #define SPI_MISO    p6
 #define SPI_SCK     p7
 #define SPI_CS      p11
 // KL25Z Pin for MFRC522 reset
 #define MF_RESET    p8
 // KL25Z Pins for Debug UART port
 //Serial     DebugUART(UART_TX, UART_RX);
 //MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET);                              


// Nucleo Pin for MFRC522 reset (pick another D pin if you need D8)

//Serial connection to PC for output
Serial pc(USBTX, USBRX);

MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
FM_Radio FM1(p21,p22,p23,p24,p25);
   
 


int main() {

 pc.printf("starting...\n");


  RfChip.PCD_Init();
 
  
     
     
while (true) {
  

    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(50);
      continue;
    }

    // Select one of the cards
    if ( !RfChip.PICC_ReadCardSerial())
    {
      wait_ms(50);
      continue;
       pc.printf(" error !!! \n\r");
    }
    else
    {
        pc.printf(" succes !!! \n\r");
        FM1.RadioPowerOn(); 
        wait(1);
        FM1.NextStation();
        
       
        pc.printf(" done !! \n\r");
        
        //FM1.VolumeUp();
        //FM1.VolumeUp();
    }

    

    // Print Card UID
    pc.printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      pc.printf(" %X02", RfChip.uid.uidByte[i]);
    }
    pc.printf("\n\r");

    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    pc.printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    wait_ms(1000);
  } 
     

}
     
     
     
     
/*int main(void)  
  
{
     
    FM_Radio FM1(p21,p22,p23,p24,p25);
     
     wait(5);
     
     FM1.RadioPowerOn(); 
     
     wait(5);
     
     FM1.RadioPowerOff(); 
     
  

}*/
     
     
     
       
    
     
     

