#ifndef SERIAL485_H
#define SERIAL485_H

#include "mbed.h"
#include "pinmap.h"

class Serial485: public RawSerial
{
public:
    Serial485(PinName tx, PinName rx, PinName rts);
    virtual ~Serial485();
    void set9thBit(uint8_t value);
    void puts9(const uint16_t *data, uint16_t count);
    void putc9(uint16_t data);
    uint16_t getc9();
    uint32_t getBaudRate();
    
    uint32_t uart_instance;
    
private:
    void enableRS485();
    void disableRS485();
    
    PinName rts;
    static const PinMap PinMap_UART_RTS[];
};

#endif