/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "pixart_lcm.h"
#include "pat9125_i2c.h"
#include "pat9125_mbed.h"

pat9125_mbed_state_s g_pat9125_mbed_state ;
pat9125_mbed *gp_pat9125_mbed ;
pixart_lcm *gp_pixart_lcm ;


Serial  pc(USBTX, USBRX);
#define I2C_SDA_PIN I2C_SDA0
#define I2C_SCL_PIN I2C_SCL0
//DigitalIn sdaDummy(I2C_SDA0, PullUp);
//DigitalIn sclDummy(I2C_SCL0, PullUp);
pat9125_i2c *gp_pat9125_i2c;//(I2C_SDA0, I2C_SCL0);
SPI spi(SPI_PSELMOSI0, NC, SPI_PSELSCK0);

DigitalOut PIN_LCM_CSB(SPI_PSELSS0);
DigitalOut PIN_LCM_RSTB(p20);
DigitalOut PIN_LCM_RS(p23);

InterruptIn PIN_SEN_MOTION(p15);
DigitalIn motionDummy(p15, PullUp);
DigitalIn PIN_BTN_L(p1);
DigitalIn PIN_BTN_R(p2);

DigitalOut PIN_GLED(p14);
DigitalOut PIN_RLED(p17);
#define I2C_ADDRESS    0x73

//-----------------------------------------------------------------------
int main(void)
{
    char addr = 0;
    char data ;
    pc.set_flow_control(SerialBase::Disabled) ;
    pc.baud(115200);
    pc.printf("---------- Pixart PAT9125 Demo\n");  

    // +++++++ LCM Initialization +++++++ //
    // Chip must be deselected
    PIN_LCM_CSB = 1 ;

    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,3);
    spi.frequency(1000000);
    gp_pixart_lcm = new pixart_lcm(&spi, &PIN_LCM_CSB, &PIN_LCM_RSTB, &PIN_LCM_RS) ;
    // ------- LCM Initialization ------- //
    
    // +++++++ PAT9125 Initialization +++++++ //
    gp_pat9125_i2c = new pat9125_i2c(I2C_SDA_PIN, I2C_SCL_PIN);
    gp_pat9125_i2c->frequency(400000); 
    g_pat9125_mbed_state.p_i2c = gp_pat9125_i2c;
    g_pat9125_mbed_state.p_pc = &pc;
    g_pat9125_mbed_state.pBTN_L = &PIN_BTN_L ;
    g_pat9125_mbed_state.pBTN_R = &PIN_BTN_R ;
    g_pat9125_mbed_state.pINT = &PIN_SEN_MOTION;
    g_pat9125_mbed_state.pRLED = &PIN_RLED;
    g_pat9125_mbed_state.pGLED = &PIN_GLED;
    g_pat9125_mbed_state.pLCM = gp_pixart_lcm;    
    g_pat9125_mbed_state.slave_id = (I2C_ADDRESS << 1);
    g_pat9125_mbed_state.sen_status = 0;
    
    gp_pat9125_mbed = new pat9125_mbed(&g_pat9125_mbed_state) ;        
    gp_pixart_lcm->LCM_DisplayString_Boot(g_pat9125_mbed_state.sen_status);
    
    if(g_pat9125_mbed_state.sen_status == true) 
    {
        pc.printf("Initial Sensor ... Done\n");
    }
    else    
    {
        pc.printf("Initial Sensor ... Fail\n");
    }
    while(true)
    {
      gp_pat9125_mbed->task();
    }
}
