#ifndef UK_AC_HERTS_SMARTLAB_XBEE_SerialData
#define UK_AC_HERTS_SMARTLAB_XBEE_SerialData

#include "mbed.h"
#include "ISerial.h"

/// The detailed implementation of ISerial, which is responsible for sending and receiving seial data.
class SerialData: public ISerial
{
private:
    /// mbed serial port interface.
    Serial * serialPort;

public:
    /** Create a SerialData instance which using pin tx and rx. 
    *
    * @param tx data transmission line
    * @param rx data receiving line
    *
    */
    SerialData(PinName tx, PinName rx);
     /** Create a SerialData instance which using pin tx and rx. 
    *
    * @param tx data transmission line
    * @param rx data receiving line
    * @param baudRate baud rate
    *
    */
    SerialData(PinName tx, PinName rx, int baudRate);
    
    ~SerialData();

    /**
    * Read the next avaliable data.
    *
    * @returns [0x00-0xFF], -1 means data not avaliable.
    *
    */
    virtual int readByte();

    /**
    * Write one byte of data.
    *
    * @param data [0x00-0xFF]
    *
    */
    virtual void writeByte(char data);
    
    /** Check if the serial port is open, not implemented and has no affect,
    * @returns always true
    */
    virtual bool isOpen();

    /// Open the serial port, not implemented and has no affect.
    virtual void open();
    
    /// Close the serial port, not implemented and has no affect.
    virtual void close();
    
    /** Check if data is ready to read.
    * @returns true data avaliable.
    *          false data not avaliable.
    */
    virtual bool peek();
};

#endif