#ifndef TUIASI_PIXYLINKUART_H
#define TUIASI_PIXYLINKUART_H

#include "Serial.h"
#include "PixyLink.h"

class PixyLinkUART : public PixyLink, private Serial
{
public:
    PixyLinkUART(PinName tx, PinName rx) :
        Serial(tx, rx) {
        baud(38400);
    };

    virtual uint16_t getWord() {
        uint8_t data[2] = {0, 0};
        read(data, 2);
        return ((uint16_t)data[1] << 8) | data[0];
    };

    virtual uint8_t getByte() {
        uint8_t data = 0;
        read(&data, 1);
        return data;
    };

    virtual int8_t send(uint8_t *data, uint8_t len) {
        return write(data, len);
    };


private:
};
#endif //TUIASI_PIXYLINKUART_H