#include "mbed.h"
#include "fct.h"
#define TIC_POSITION 0.0005
#define PERIOD_SERVO 0.01999

Serial pc(USBTX, USBRX); // tx, rx - Liaison série
Serial device(p28, p27);  // tx, rx - Liaison série
DigitalOut Servo(p21);

char c;
char msg[15];
int count=0;
char *token;
int MG, MD, bout1,bout2,bp;
Ticker tic1;
Timer t_servo;
int POSITION;
float KVIT=1;
void servo_position( void)
{
    float t = t_servo.read();
    if(t>=PERIOD_SERVO) 
    {
        t_servo.reset();
    }
    if(t>=0.001+(POSITION /100000.0)) 
    {
        Servo.write(0);
    } 
    else 
    {
        Servo.write(1);
    }
}


int main()
{

    init();
    pc.baud(19200);
    device.baud(2400);
    device.format(8,SerialBase::None,2);
    vitmoteur(0,0);
    t_servo.start();
    tic1.attach(&servo_position,TIC_POSITION);
    while(1) {
        
        if(bout1==1) 
        {
            POSITION=-35;
        } 
        else 
        {
            POSITION=80;
        }
        if(bout2==1)
        {
            KVIT=1.5;
        }
        else
        {
            KVIT=1;
        }
        if(device.readable()) 
        {
            c=device.getc();
            if(c=='*') 
            {
                msg[count] = c;
                if(count>=7) 
                {

                    pc.printf("msg = %s\n\r",msg);

                    token = strtok(msg," *");
                    //printf("token = %s\n\r",token);
                    MG= atoi(token);
                    //printf("MG=%d\n\r",MG);

                    token = strtok(NULL, " *");
                    //printf("token = %s\n\r",token);
                    MD= atoi(token);
                    //printf("MD=%d\n\r",MD);

                    token = strtok(NULL, " *");
                    //printf("token = %s\n\r",token);
                    bout1= atoi(token);
                    //printf("bout1=%d\n\r",bout1);

                    token = strtok(NULL, " *");
                    //printf("token = %s\n\r",token);
                    bout2= atoi(token);
                    //printf("bout2=%d\n\r",bout2);

                    vitmoteur(MG*KVIT,MD*KVIT);

                    for (int i=0; i<15; i++) 
                    {
                        msg[i]=0;
                    }
                    count=0;
                } 
                else 
                {
                    for (int i=0; i<15; i++) 
                    {
                        msg[i]=0;
                    }
                    count=0;
                    //vitmoteur(0,0);
                }
            } 
            else 
            {

                msg[count] = c;
                //pc.printf("%c\n\r",c);
                //pc.putc(device.getc());
                count=count+1;

                if(count>13) {
                    for (int i=0; i<15; i++) {
                        msg[i]=0;
                    }
                    count=0;
                }
            }
        }
    }
}
