#include "mbed.h"
#include "fct.h"


void vitmoteur(float VitG, float VitD)
{
    if(VitG<0) {
        VitG=-1*VitG;
        cmdI2C=cmdI2C&0xfe; //passe le moteur gauche en marche arriere 00000001
    } else {
        cmdI2C=cmdI2C|0x01; // marche avant 11110111 mot gauche
    }
    if(VitD<0) {
        VitD=-1*VitD;
        cmdI2C=cmdI2C&0xfd; //passe le moteur gauche en marche arriere 00000100
    } else {
        cmdI2C=cmdI2C|0x02;//marche avant 11111011 mot droit
    }
    monI2C.write(ADR_PCF,&cmdI2C,1);
    MotG.pulsewidth(((100-VitG)/100.0)*PERIOD);
    MotD.pulsewidth(((100-VitD)/100.0)*PERIOD);
}


void init(void)
{

    MotG.period(PERIOD);
    MotD.period(PERIOD);
    vitmoteur(0,0);
}


    