#include "mbed.h"
#include "digital_filter.h"


Serial pc(USBTX,USBRX);

int main()
{
    pc.baud(460800);

    double coef_b[4] = {0.0408, 0.1224, 0.1224, 0.0408};    // Les 4 coefficients ai
    double coef_a[3] = {-1.2978, 0.7875, -0.1632};          // Les 3 coefficients bj
    double echantillons[32] = {0.7362, 0.2071, 1.2774, 1.0, 0.5703, 1.2071, 0.0291, 0.0, -0.0291, -1.2071, -0.5703, -1.0, -1.2774, -0.2071, -0.7362, 0.0,
                               0.7362, 0.2071, 1.2774, 1.0, 0.5703, 1.2071, 0.0291, 0.0, -0.0291, -1.2071, -0.5703, -1.0, -1.2774, -0.2071, -0.7362, 0.0};
    digital_filter mon_filtre;

    init_digital_filter(&mon_filtre, coef_a, 4, coef_b, 3); // Initialisation du filtre avec les coefficients de la fonction de transfert

    for(char i = 0; i < 32; i++)
    { // On filtre les échantillons
        pc.printf("Echantillon numero %d : %lf\t | Apres filtrage : %lf\n\r", i, echantillons[i], filter_next_sample(&mon_filtre, echantillons[i]));
    }

    while(1)
    {
        wait(1);
    }
}
