/**
 *  digital_filter.h
 *
 *  Auteur : Ferdinand Piette (Avril 2011)
 *  Version : 1.0b
 *
 *  Fourni des fonctions permettant d'appliquer des filtres numériques
 *  ayant pour fonction de transfert :
 *
 *          b0*z + b1*z^-1 + ... + bN*z^-N
 *  H(z) = --------------------------------
 *           1 + a1*z^-1 + ... + aM*z^-M
 */

#ifndef DEF_digital_filter
#define DEF_digital_filter

    /**
     * Structure stockant les coefficients du filtre
     */
    typedef struct digital_filter_coefficient
    {
        double * coef_a;        // Les coefficients a1..aN
        double * coef_b;        // Les coefficients b0..bM
        int numberOfCoef_a;     // Le nombre de coefficients a
        int numberOfCoef_b;     // Le nombre de coefficients b
    } digital_filter_coefficient;

    /**
     * Structure stockant les coefficiants du filtre et les échantillons et résultats nécessaires
     */
    typedef struct digital_filter
    {
        double * samples;       // Les échantillons en entrées du filtre
        double * results;       // Le résultat de la sortie du filtre
        int current_sample;     // L'indice du tableau où se trouvera le prochain échantillon
        int previous_result;    // L'indice du tableau où se trouve la sortie du filtre pour l'échantillon courrant
        struct digital_filter_coefficient transfert_function;   // La structure stockant les coefficients du filtre
    } digital_filter;

    void init_digital_filter_coefficient(struct digital_filter_coefficient *, double *, int, double * , int);   // Initialise les coefficients du filtre
    void init_digital_filter(struct digital_filter *, double *, int, double * , int);                           // Initialise le filtre
    double filter_next_sample(digital_filter *, double);        // Calcule la sortie du filtre pour un nouvel échantillon

    int modulo(int, int);   // Fonction modulo pour buffer circulaire (modulo(-1, 3) = 2)

#endif
