#include "mbed.h"
#include <as5048spi.h>
#define PI 3.1415926
 
// The sensors connection are attached to pins 5-8
As5048Spi sensor1(p5, p6, p7,1);


Serial pc(USBTX, USBRX); // tx, rx
float vitesse,delta_deg,tour_sec;
int degrees_av,degrees;
Timer delta_t;


int main() {
    pc.baud(38400);
    delta_t.start();
    while(1) {
        // 
        const int* angles = sensor1.read_angle();
        
        int angle = angles[0];
        
        // The read angle returns the value returned over the SPI bus, including parity bit
        //pc.printf("Read result: %x\r\n", angle);
        
        if( As5048Spi::parity_check(angle) )
        { 
            degrees = As5048Spi::degrees(angle)/100;  
            pc.printf("deg=%d\n\r", degrees);
            // Convert range from 0 to 2^14-1 to 0 - 360 degrees
            /*degrees_av=degrees;
            degrees = As5048Spi::degrees(angle)/100;
            delta_deg=(degrees-degrees_av);
            if(delta_deg<0)
            {
                delta_deg=delta_deg+360;
            }
            tour_sec=((delta_deg)/delta_t.read())/(11*360);
            vitesse=tour_sec*5.9*PI;
            delta_t.reset();
            //vitesse=vitesse/(6.283185*11);
            
            pc.printf("vitesse=%0.2f m/sec \n\r",vitesse);
            
            //pc.printf("Parity check succesfull.\r\n");
            
            //pc.printf("Angle: %i degrees\r\n", degrees );*/
        }
        else
        {
            //pc.printf("Parity check failed.\r\n");
        }

    }
}

