#include "mbed.h"
#include "ikarashiMDC.h"
#include "wheel_an.h"
#include "controller.h"
#define PI 3.141593

Controller pad(PC_12, PD_2, 208);
Serial pc(USBTX, USBRX, 115200);
Serial serial(PC_6, PC_7, 115200);
DigitalOut serialcontrol(D2);

ikarashiMDC ikarashi[]
{
    ikarashiMDC(&serialcontrol,2,0,SM,&serial),
    ikarashiMDC(&serialcontrol,2,1,SM,&serial),
    ikarashiMDC(&serialcontrol,2,2,SM,&serial)
};

Wheelan wheel[]
{
    Wheelan(PI * 1 / 6),
    Wheelan(PI * 5 / 6),
    Wheelan(PI * 9 / 6)
};

int main()
{
    int b[11];
    double rad[2],dis[2];
    double value[3];
    ikarashi[0].braking = true;
    while(1){
        if(pad.receiveState()){
            for(int i = 0; i < 13; i++){
                b[i] = pad.getButton1(i);
            }
            for(int i = 0; i < 2; i++){
                rad[i] = pad.getRadian(i);
                dis[i] = pad.getNorm(i);
                rad[i] = PI - rad[i];
            }

            for (int i = 0; i < 3; ++i)
            {
                value[i] = wheel[i].an_uc(rad[1], dis[1]);
            }

            if(b[8] == 1 && b[10] == 0) {
                value[0] -= 0.3;
                value[1] -= 0.3;
                value[2] -= 0.3;
            } else if (b[10] == 1 && b[8] == 0) {
                value[0] += 0.3;
                value[1] += 0.3;
                value[2] += 0.3;
            }

            for (int i = 0; i < 3; ++i)
            {
                pc.printf("%lf", value[i]);
                ikarashi[i].setSpeed(value[i]);
            }
            pc.printf("\n\r");

        } else {
            pc.printf("error\n\r");
        }
    }
}