#include "mbed.h"           //wheel test
#include "ikarashiMDC.h"
#include "controller.h"
#define PI 3.141593

Controller pad(PC_12, PD_2, 208);
Serial pc(USBTX, USBRX, 115200);
Serial serial(PC_6,PC_7);
DigitalOut serialcontrol(D2);
DigitalOut stop(PB_12,PB_2);

ikarashiMDC ikarashi[] {
    ikarashiMDC(&serialcontrol,2,0,SM,&serial),
    ikarashiMDC(&serialcontrol,2,1,SM,&serial),
    ikarashiMDC(&serialcontrol,2,2,SM,&serial)
};

int main()
{
    serial.baud(115200);
    ikarashi[0].braking = true;
    int b[11];
    float rad[2],dis[2];
    double value[3];
    while(1){

/*
      7       9
      8       10
    -------------
    1    | |   3  
         | | 2   4
    0  --| |-- 5
      |12| |11|  6
                 

*/

    ////stick button////
        if(pad.receiveState()){
            for(int i = 0; i < 13; i++){
                b[i] = pad.getButton1(i);
            }
            for(int i = 0; i < 2; i++){
                rad[i] = pad.getRadian(i);
                dis[i] = pad.getNorm(i);
                ////change stick value////
                rad[i] = PI - rad[i];
            }

            ////set speed////
            
            value[0] = sin(rad[1] - PI * 1 / 6) * dis[1];
            value[1] = sin(rad[1] - PI * 5 / 6) * dis[1];
            value[2] = sin(rad[1] - PI * 9 / 6) * dis[1];
            
            if(b[8] == 1 && b[10] == 0) {
                value[0] -= 0.3;
                value[1] -= 0.3;
                value[2] -= 0.3;
            } else if (b[10] == 1 && b[8] == 0) {
                value[0] += 0.3;
                value[1] += 0.3;
                value[2] += 0.3;
            }
            
            pc.printf("%f", value[0]);
            pc.printf("%f", value[1]);
            pc.printf("%f", value[2]);

            pc.printf("\n\r");
            ikarashi[0].setSpeed(value[0]);
            ikarashi[1].setSpeed(value[1]);
            ikarashi[2].setSpeed(value[2]);

        }else{
            pc.printf("error\n\r");
            for (int i = 0; i < 3; i++)
            {
                ikarashi[i].setSpeed(0);
            }
        }
    }
}
