#ifndef SAMPLE02_H
#define SAMPLE02_H
#define PI 3.141592653589793238462643383219502884

#include "mbed.h"

class Sample {
    public:

        /**
         * コンストラクタ
         * @param accdis_   加速距離
         * @param decdis_   減速距離(誤差あり。大きめに調整すると良い)
         * @param maxspeed_ 最大速度(?)
         */
        Sample(double accdis_, double decdis_, double maxspeed_, double s_vector_);

        /**
         * 目標点の設定
         * @param targetx_ 目標点のx座標
         * @param targety_ 目標点のy座標
         * @param startx_  開始地点のx座標
         * @param starty_  開始地点のy座標
         */
        void target_xy(int targetx_, int targety_, int startx_, int starty_);

        /**
         * S字に変化する速度を計算
         * @param now_x 現在地点のx座標
         * @param now_y 現在地点のy座標
         */
        void calculate(int now_x, int now_y);

        double getvalue_x();

        double getvalue_y();
        

/***
 *  accDis   : 加速中に進む距離
 *  decDis   : 減速中に進む距離
 *  maxspeed : 最大速度
 **/
        double accdis;
        double decdis;
        double accdis2;
        double decdis2;
        double maxspeed;

        double accsec;
        double decsec;

        double s_vector;
//  s_vector : start speed
        double vector;

        double targetx;
        double targety;
        double startx;
        double starty;
        double nowx;
        double nowy;

/***
 *  tergetDis : 開始地点から目標点までの距離
 *  tergetRad : 現在地と目標点がなす角度
 *  nowDis    : 進んだ距離
 **/
        double targetDis;
        double targetRad;
        double nowDis;
        double middledis;
        double counter;

};
 
#endif