#ifndef SAMPLE03_H
#define SAMPLE03_H
#define PI 3.141592653589793238462643383219502884

#include "mbed.h"
#include "PID.h"

class Sample {
    public :

        /***
         *  コンストラクタ
         *  @param accdis_   加速距離
         *  @param decdis_   減速距離
         *  @param maxspeed_ 最大速度
         **/
        Sample(float accdis_, float decdis_, float maxspeed_, float s_vector_);


        /***
         *  目標点の設定
         *  @param targetx_ 目標点のx座標
         *  @param targety_ 目標点のy座標
         *  @param startx_  開始地点のx座標
         *  @param starty_  開始地点のy座標
         **/
        void target_xy(int targetx_, int targety_, int startx_, int starty_);
        

        /***
         *  計算
         *  param now_x 現在地点のx座標
         *  param now_y 現在地点のy座標
         **/
        void calculate(int now_x, int now_y);


        /***
         *  PID
         *
         **/
        void PID(float Inputmin, float Inputmax);

        float getvalue_x();

        float getvalue_y();
    
//    private :
    
/***
 *  accDis   : 加速中に進む距離
 *  decDis   : 減速中に進む距離
 *  maxspeed : 最大速度
 **/
        float accdis;
        float decdis;
        float maxspeed;

        float accsec;
        float decsec;

        float s_vector;
//  s_vector : start speed
        float vector;

        float targetx;
        float targety;
        float startx;
        float starty;
        float nowx;
        float nowy;
        PID dec;

/***
 *  tergetDis : 開始地点から目標点までの距離
 *  tergetRad : 現在地と目標点がなす角度
 *  nowDis    : 進んだ距離
 **/
        float targetDis;
        float targetRad;
        float nowDis;
        float middledis;
        float counter;
};
 
#endif