#include "sample03.h"

Sample::Sample(float accdis_, float decdis_, float maxspeed_, float s_vector_):
    dec(0.5,0.0,0.01,0.01)
{
    accdis   = accdis_;
    decdis   = decdis_;
    maxspeed = maxspeed_;
    s_vector = s_vector_;
}

void Sample::target_xy(int targetx_, int targety_, int startx_, int starty_)
{
    targetDis = hypot((float)(startx_-targetx_), (float)(starty_-targety_));
    if (targetDis > accdis+decdis) {
        startx    = startx_;
        starty    = starty_;
        targetx   = targetx_;
        targety   = targety_;
        accsec    = 2.0 / maxspeed * accdis;
        decsec    = 2.0 / maxspeed * decdis;
        middledis = targetDis - accdis - decdis;
        dec.setSetPoint(targetDis);
    }
}

void Sample::calculate(int now_x, int now_y)
{
    nowx      = now_x;
    nowy      = now_y;
    nowDis    = hypot((startx-nowx),(starty-nowy));
    targetRad = atan2((double)(targety-nowy), (double)(targetx-nowx));

    if ( nowDis < accdis ) {

        counter = sqrt(2.0*accsec/maxspeed*nowDis);
        vector  = s_vector + (-1.0 * sin((2.0*PI/accsec)*counter) + (2.0*PI/accsec)*counter) / ((2.0*PI)/(maxspeed-s_vector));

    } else if ( nowDis >= accdis && nowDis < accdis+middledis ) {

        vector = maxspeed;

    } else if ( nowDis > (accdis+middledis) ) {
        
        dec.setProcessValue(nowDis);
        vector = dec.compute();

    }
}

void Sample::PID(float Inputmin, float Inputmax)
{
    dec.setInputLimits(Inputmin,Inputmax);
    dec.setOutputLimits(-maxspeed,maxspeed);
    dec.setBias(0);
    dec.setMode(1);
}

float Sample::getvalue_x()
{
    return vector * cos(targetRad);
}

float Sample::getvalue_y()
{
    return vector * sin(targetRad);
}