//-------------------------------------------------------
//  Class for LCD, AQM0802A (Header)
//
//  Default pin assignments
//      D14  SDA ---- to pin4 of LCD module
//      D15  SCL ---- to pin3 of LCD module
//
//  Assignment of I2C ports
//                SDA                SCL
//      I2C1   PB_7 or PB_9(D14)  PB_6(D10) or PB_8(D15)
//      I2C2   PB_3(D3)           PB_10(D6)
//      I2C3   PB_4(D5) or PC_9   PA_8(D7)
//
//     01234567 x
//    +--------+
//   0|        |
//   1|        |
//   y+--------+
//   
//
//-------------------------------------------------------

#ifndef AQM0802_H
#define AQM0802_H

#include "mbed.h"

class aqm0802 {
public :
    // Constructor
    aqm0802(PinName sda, PinName scl);

    // Send command
    void cmd(char x);

    // Write string
    void print(const char *s);
    
    void print(int num);

    // Set cursol
    void setCursor(uint8_t x,uint8_t y);

    // Set contrast
    void setContrast(uint8_t c);

    void contdata(char x);

    void lastdata(char x);

    void setCG(int src,int dst,int len);
    
    void clear();

//private :
    const int AQCM0802_addr = 0x7C;
    
    I2C i2c_;
    unsigned char cg[13 * 8] = {
0x0F,0x10,0x10,0x0E,0x01,0x01,0x1E,0x00, // S
0x11,0x11,0x11,0x15,0x15,0x15,0x0A,0x00, // W
0x0E,0x04,0x04,0x04,0x04,0x04,0x0E,0x00, // I
0x1F,0x04,0x04,0x04,0x04,0x04,0x04,0x00, // T
0x0E,0x11,0x10,0x10,0x10,0x11,0x0E,0x00, // C
0x11,0x11,0x11,0x1F,0x11,0x11,0x11,0x00, // H
0x0F,0x10,0x10,0x0E,0x01,0x01,0x1E,0x00, // S
0x0E,0x11,0x10,0x10,0x10,0x11,0x0E,0x00, // C
0x0E,0x04,0x04,0x04,0x04,0x04,0x0E,0x00, // I
0x1F,0x10,0x10,0x1E,0x10,0x10,0x1F,0x00, // E
0x11,0x11,0x19,0x15,0x13,0x11,0x11,0x00, // N
0x0E,0x11,0x10,0x10,0x10,0x11,0x0E,0x00, // C
0x1F,0x10,0x10,0x1E,0x10,0x10,0x1F,0x00  // E
};

};
#endif