#include "aqm0802.h"

aqm0802::aqm0802(PinName sda, PinName scl)
    : i2c_(sda, scl)
{
    thread_sleep_for(40);
    // LCD initialize
    cmd(0x39); // function set
    cmd(0x14); // interval osc
    cmd(0x70); // contrast Low
    cmd(0x56); // contast High/icon/power
    cmd(0x6C); // follower control
    thread_sleep_for(200);
    cmd(0x38); // function set
    cmd(0x0C); // Display On
    cmd(0x01); // Clear Display
    thread_sleep_for(200);
}

void aqm0802::cmd(char x)
{
    char data[2];
    data[0] = 0x00; // CO = 0,RS = 0
    data[1] = x;
    i2c_.write(AQCM0802_addr, data, 2);
}

void aqm0802::contdata(char x)
{
    char data[2];
    data[0] = 0xC0; //0b11000000 CO = 1, RS = 1
    data[1] = x;
    i2c_.write(AQCM0802_addr, data, 2);
}

void aqm0802::lastdata(char x)
{
    char data[2];
    data[0] = 0x40; //0b11000000 CO = 0, RS = 1
    data[1] = x;
    i2c_.write(AQCM0802_addr, data, 2);
}

void aqm0802::print(const char *s)
{
    while(*s) {
    if (*(s + 1)) {
        contdata(*s);
    } else {
        lastdata(*s);
    }
        s++;
    }
}

void aqm0802::print(int num)
{
    char itoa[8];
    sprintf(itoa, "%d", num);
    print(itoa);
}

void aqm0802::setCursor(uint8_t x,uint8_t y)
{
    cmd(0x80 | (y*0x40 + x));
}

void aqm0802::setCG(int src,int dst,int len)
{
    cmd(0x38);
    cmd(0x40 + dst);

    for (int i = 0;i < len;i++) contdata(cg[src + i] * (src>=0));
}

void aqm0802::setContrast(uint8_t c)
{
    cmd(0x39);
    cmd(0x70 | (c & 0x0f)); // contrast Low
    cmd(0x5C | ((c >> 4) & 0x03)); // contast High/icon/power
    cmd(0x38);
}

void aqm0802::clear()
{
    cmd(0x01);
}