#include "mbed.h"
#include "PS3.h"
#include "pinconfig_main.h"
#include "ikarashiMDC.h"

DigitalOut led1(LED1);
PS3 ps3(FEPTX, FEPRX);
DigitalOut serialcontrol(D10);
Serial serial(mdTX, mdRX, 115200);
Serial pc(USBTX, USBRX,115200);

ikarashiMDC motor[]=
{
    ikarashiMDC(&serialcontrol,1,0,SM,&serial),
    ikarashiMDC(&serialcontrol,1,1,SM,&serial),
    ikarashiMDC(&serialcontrol,1,2,SM,&serial),
//    ikarashiMDC(&serialcontrol,0,3,SM,&serial)
};

int main() {
    
    int b[12], stick[4], trigger[2];
    double value[2];
    
    while (1) {
    /*ボタンスイッチ*/
    for(int i = 0; i < 12; i++) {
        b[i] = ps3.getButton(i);
    }
//    for(int i = 0; i < 4; i++) pc.printf("%2d",b[i]);
//    pc.printf(" | ");
//    for(int i = 4; i < 6; i++) pc.printf("%2d",b[i]);
//    pc.printf(" | ");
//    for(int i = 6; i < 10; i++) pc.printf("%2d",b[i]);
//    pc.printf(" | ");
//    for(int i = 10; i < 12; i++) pc.printf("%2d",b[i]);
//    pc.printf(" | ");
    /*ジョイスティック*/
    for(int i = 0; i < 2; i++) {
        stick[2*i] = ps3.getStick(2*i) - 125;
        stick[2*i+1] = -1*ps3.getStick(2*i+1) + 125;
    }
//    for(int i=0; i<4; i++) pc.printf("%4d",stick[i]);
    /*トリガースイッチ*/
    for(int i = 0; i < 2; i++) {
        trigger[i] = ps3.getTrigger(i);
//        pc.printf("%4d",trigger[i]);
    }
    if (b[4]) {
        value[0] = 0.3;
    } else if (b[5]) {
        value[0] = -0.3;
    } else {
        value[0] = 0;
    }
    if (b[0]) {
        value[1] = 0.6;
    } else if (b[1]) {
        value[1] = -0.7;
    } else {
        value[1] = 0;
    }
    motor[0].setSpeed(value[0]);
    motor[1].setSpeed(value[1])*(10.0/7.0);//このモーターだけ遅いのではやくしている
    motor[2].setSpeed(value[1]);
    //pc.printf("\r\n");
    }
}