/**
 *  @file   SerialArduino.cpp
 *  @brief  Arduino受信用ライブラリ
 *  @author 高木宏陸
 *  @date   22/10/4
 */
#ifndef SA_H
#define SA_H

#include "mbed.h"

class SerialArduino
{
public:
    SerialArduino(PinName TX, PinName RX, int baud);
//attachの関数　使用の必要なし
    void serialLoop();
//debug用　ヘッダー1を返す
    uint8_t getHedder1();
//debug用　ヘッダー1を返す
    uint8_t getHedder2();
//タイムアウトカウントを返す
    uint16_t getTimeoutCount();
//通信確認兼更新　毎ループ処理すること 通信できてれば1を返す
    bool getState(uint8_t *data);
    
//private:
//    uint8_t buff[3];
    bool state;
    uint8_t hedder1;
    uint8_t hedder2;
    uint8_t b0;
    uint8_t b1;
    uint16_t button;
    uint8_t timeout;
    int past,timeoutCount;
    bool b[12];
    uint8_t trigger[2];
    uint8_t stick[4];
    int i;
    RawSerial mini;
    
};



#endif