/**
 *  @file   SerialArduino.cpp
 *  @brief  Arduino受信用ライブラリ
 *  @author 高木宏陸
 *  @date   22/10/4
 */
#include "SerialArduino.h"

SerialArduino::SerialArduino(PinName TX,PinName RX, int baud)
: mini(TX,RX,baud)
{
//    mini.attach(callback(this,&SerialArduino::serialLoop), SerialBase::RxIrq);
    state=0;
    mini.attach(callback(this, &SerialArduino::serialLoop));
    
    for (int i=0; i<12; i++) b[i] = 0;
    for (int i=0; i<2; i++) trigger[i] = 0;
    for (int i=0; i<4; i++) stick[i] = 0;
    
}

void SerialArduino::serialLoop()
{
    hedder1 = mini.getc();
    hedder2 = mini.getc();
    if(hedder1==0xff && hedder2==0xee) {
#if 1
        b0 = mini.getc();
        b1 = mini.getc();
        for (int i=0; i<4; i++) {
             stick[i] = mini.getc();
        }
        for (int i=0; i<2; i++) {
             trigger[i] = mini.getc();
        }
#else 
        b0 = 1;
        b1 = 2;
        for (int i=0; i<4; i++) {
             stick[0] = 4;
        }
        for (int i=0; i<2; i++) {
             trigger[0] = 8;
        }
#endif
        timeout = mini.getc();

    }
}

bool SerialArduino::getState(uint8_t *data)
{
    //timeout    
    if(timeout == past)
    {
        if(state) timeoutCount++;    
    }
    else
    {
        timeoutCount = 0;
        state=1;
    }
    if(timeoutCount > 20)
    {
        state=0;
    }
    past = timeout;
    
    data[0] = b0;
    data[1] = b1;
    data[2] = stick[0];
    data[3] = stick[1];
    data[4] = stick[2];
    data[5] = stick[3];
    data[6] = trigger[0];
    data[7] = trigger[1];
    data[8] = timeout;

    return(state);
}

uint8_t SerialArduino::getHedder1()
{
    return(hedder1);
}

uint8_t SerialArduino::getHedder2()
{
    return(hedder2);
}

uint16_t SerialArduino::getTimeoutCount()
{
    return(timeout);
}


