#ifndef OMNI_POSITION_H
#define OMNI_POSITION_H

#include "mbed.h"

#define OP_SERIAL_BUFFER_SIZE 9
#define OP_HEADER_FIRST_BYTE 0xEE
#define OP_HEADER_SECOND_BYTE 0xFF
#define OP_DEFAULT_BAUD 115200

class OmniPosition : public RawSerial {
 public:
  OmniPosition(PinName serialTX, PinName serialRX);

  int16_t getX();
  int16_t getY();
  float getTheta();

  void reset();

 private:
  DigitalOut debugled;
  void receiveByte();
  void checkData();

  uint8_t buffer[9];
  uint8_t bufferSize;
  uint8_t bufferPoint;
  uint8_t receivedBytes;
  int16_t X;
  int16_t Y;
  int16_t theta;
};

#endif

#ifndef M_PI
#define M_PI 3.141592653589793238462643383219502884
#endif

