/** @ikarashiSV.h
 *
 * NHK2021Bチーム　電磁弁のライブラリです
 * @attention 回路が悪いのか電磁弁が悪いのかわかりませんが、訳あってpin_c,pin_dの代入値を本来とは逆にしています。
 *            追記　　なんか治りました
 */
#ifndef ikarashi_SOLENOID
#define ikarashi_SOLENOID

#include "mbed.h"

/** ikrashiSV
 *
 * 電磁弁が動かせます
 */
class ikarashiSV
{
public:

    /** コンストラクタ
     *
     * @param pin_a 下の電磁弁
     * @param pin_b ↑同じ
     *
     * @param pin_c 上の電磁弁
     * @param pin_d ↑同じ
     */
    ikarashiSV(PinName pin_a,PinName pin_b,PinName pin_c,PinName pin_d);
    
    /** 使っても使わなくてもいいやつ
     *
     * state って言いう変数に+1します（state初期値0）
     */
    void add_state();
    
    /** 大本命関数
     *
     * _state = 1　・・・ 投げる
     * _state = 2　・・・ 戻る
     * _state = 0　・・・ 開放
     * @param _state 条件分岐用変数
     */
    void solenoid(int _state);
    
    /** 電磁弁の状態を確認する関数
     * 押していたらpushで、引いていたらpullです
     */
    void solenoid_show();
    
    /** 使わなくてもいい（n回目）
     *
     * @return state を返します
     */
    int state_show();
    int solenoid_status;
private:
    int state;
    int _state;
    DigitalOut port_a;//1　下の電磁弁
    DigitalOut port_b;//

    DigitalOut port_c;//2　上の電磁弁
    DigitalOut port_d;//
};

/** ikarashiSV2
 * 下のエアシリンダー用のクラスです。
 * １個目のクラスとほとんど同じです
 */
class ikarashiSV2{
public:
    ikarashiSV2(PinName pin_e, PinName pin_f);
    
    /** 大本命関数その２
     * _state2 = 1 ・・・　push
     * _state2 = 0 ・・・　pull
     */
    void solenoid(int _state2);
    void solenoid_show();
    int solenoid_status2;
private:
    DigitalOut port_e;
    DigitalOut port_f;
};

#endif