/*
 Example sketch for the PS3 Bluetooth library - developed by Kristian Lauszus
 For more information visit my blog: http://blog.tkjelectronics.dk/ or
 send me an e-mail:  kristianl@tkjelectronics.com
 ハセオムニ：00:02:5B:00:A5:A5, 0x00, 0x02, 0x5B, 0x00, 0xA5, 0xA5
 一番ドングル：00:1B:DC:F4:41:E8, 0x00, 0x1B, 0xDC, 0xF4, 0x41, 0xE
 二番ドングル：00:1B:DC:F4:43:A0, 0x00, 0x1B, 0xDC, 0xF4, 0x43, 0xA0
 */

#include <PS3BT.h>
#include <usbhub.h>

// Satisfy the IDE, which needs to see the include statment in the ino too.
#ifdef dobogusinclude
#include <spi4teensy3.h>
#endif
#include <SPI.h>

USB Usb;
//USBHub Hub1(&Usb); // Some dongles have a hub inside

BTD Btd(&Usb); // You have to create the Bluetooth Dongle instance like so
/* You can create the instance of the class in two ways */
PS3BT PS3(&Btd); // This will just create the instance
// PS3BT PS3(&Btd, 0x00, 0x1B, 0xDC, 0xF4, 0x41, 0xE8); // This will also store the bluetooth address - this can be obtained from the dongle when running the sketch

uint8_t header0 = 0xFF;
uint8_t header1 = 0xEE;
bool button[12] = {};
uint8_t button0 = 0;
uint8_t button1 = 0;
uint8_t trigger[2] = {};
uint8_t stick[4] = {};
uint8_t count_timeout=0;

bool printTemperature, printAngle;

void setup() {
  Serial.begin(115200);
#if !defined(__MIPSEL__)
  while (!Serial); // Wait for serial port to connect - used on Leonardo, Teensy and other boards with built-in USB CDC serial connection
#endif
  if (Usb.Init() == -1) {
    Serial.print(F("\r\nOSC did not start PS3BT"));
    while (1); //halt
  }
  Serial.print(F("\rNo.1 Test005 send all data nodelay\n"));
}
void loop() {
  Usb.Task();

  if (PS3.PS3Connected || PS3.PS3NavigationConnected) {
    for (int i = 0; i < 8; i++) {
      button[i] = PS3.getButtonPress((ButtonEnum)(i));
      button1 = button1 << 1;
      button1 += (button[i]);
    }
    for (int i = 8; i < 12; i++) {
      button[i] = PS3.getButtonPress((ButtonEnum)(i+2));
      button0 = button0 << 1;
      button0 += button[i];
    }
    trigger[0] = PS3.getAnalogButton(L2);
    trigger[1] = PS3.getAnalogButton(R2);
    stick[0] = PS3.getAnalogHat(LeftHatX);
    stick[1] = PS3.getAnalogHat(LeftHatY);
    stick[2] = PS3.getAnalogHat(RightHatX);
    stick[3] = PS3.getAnalogHat(RightHatY);
    
#if 0
    Serial.print(header0);
    Serial.print(header1);
    Serial.print(button0);
    Serial.print(button1);
    Serial.print(trigger[0]);
    Serial.print(trigger[1]);
    Serial.print(stick[0]);
    Serial.print(stick[1]);
    Serial.print(stick[2]);
    Serial.print(stick[3]);
    Serial.print(count_timeout);
    Serial.println();
#else
    Serial.write(header0);
    Serial.write(header1);
    Serial.write(button0);
    Serial.write(button1);
    Serial.write(trigger[0]);
    Serial.write(trigger[1]);
    Serial.write(stick[0]);
    Serial.write(stick[1]);
    Serial.write(stick[2]);
    Serial.write(stick[3]);
    Serial.write(count_timeout);
#endif

    count_timeout++;
    if (count_timeout > 255) count_timeout=0;
  }
}
