/**
 *  @file   main.cpp
 *  @brief  FEP受信側プログラム
 *  @author 安澤瑠
 *  @date   21/10/11
 */
#include "mbed.h"
#include "FEP.h"

myFEP fep(D1, D0, 005);
Serial pc(USBTX, USBRX, 115200);

int main() {
    fep.StartReceive();
    uint8_t data[256];
    uint8_t temp;
    while (1) {
        temp = fep.GetData(data);
        pc.printf("%3d | %3d | %3d | %3d | %3d\r\n", data[3], data[4], data[5], data[6], fep.status);
    }
}