#include "Keyboard_Ts.h"

KeyboardTs::KeyboardTs(uint16_t uiColumnNumber){
    uiColumnX = uiColumnNumber*80;
}

enum Buttons KeyboardTs::eRead(void) {
    ts.GetState(&TS_State);
    if((! TS_State.TouchDetected) || !((TS_State.X>uiColumnX) && (TS_State.X<uiColumnX+80)) ) return NOT_A_BUTTON;
    else if( (TS_State.Y>0) && (TS_State.Y<80) ) return BUTTON_0;
    else if( (TS_State.Y>80) && (TS_State.Y<160) ) return BUTTON_1;
    else if( (TS_State.Y>160) && (TS_State.Y<240) ) return BUTTON_2;
    else return BUTTON_3;
}
