#include "Led_Lcd.h"

char* pText[] = {"0", "1", "2", "3"};

LedLcd::LedLcd(uint16_t uiColumnNumber) {
    uiColumnX = uiColumnNumber*80;
    
    lcd.SetFont(&Font24);
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_RED);
}

void LedLcd::On(uint16_t uiChosenSquare) {
    for(uint16_t i=0; i<4; i++) {
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(uiColumnX, i*80, 80, 80); 
        //-----------------------------------------------------------------
        if( uiChosenSquare != i) lcd.SetTextColor(LCD_COLOR_BLUE);
        lcd.FillRect(uiColumnX+1, (80*i)+1 , 78, 78);
        //-----------------------------------------------------------------
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(uiColumnX, i*80, (uint8_t *)pText[i], LEFT_MODE);
        }
}
