#include "mbed.h"

DigitalOut redLED(D11);
DigitalOut amberLED(D12);
DigitalOut greenLED(D13);

DigitalIn button(USER_BUTTON);

Timer t;

Serial pc(SERIAL_TX,SERIAL_RX);

float startTime = 0.0;
float stopTime = 0.0;
float duration = 0.0;

void flash(){
    redLED = 1;
    wait(2);
    redLED = 0;
    amberLED = 1;
    wait(1);
    amberLED = 0;
    greenLED = 1;
    }

int main(){
    float record = 100.0;
    t.start();
    while(1){
    flash();
    startTime = t.read();
    
    while(stopTime==0.01){
            if(button!=1){
                stopTime = t.read();
                duration = stopTime - startTime;
                pc.printf("Reaction Time = %f Seconds \r\n", duration);
                pc.printf("Record Time = %f Seconds \r\n \r\n", record);
                greenLED = 0;
                wait(5);
                if(duration<=record){
                record = duration;
                }
                duration = 0.0;
                }
            }
            stopTime = 0.01;
            wait(5.0);

        }
    }









