#include "mbed.h"
#include "cmsis_os.h"

#define V_SYNC_LEN 0.064
#define H_SYNC_LEN 0.00377
#define V_SYNC_CYCLE_LEN 16.6
#define H_SYNC_CYCLE_LEN 0.03177

DigitalOut h_sync(A4);
DigitalOut v_sync(A5);

osMutexId h_counter;
osMutexDef(h_counter);

osTimerId v_timer;
osTimerId h_timer; 

int h_num = 0;

void v_sync_loop(void const *n){
    v_sync = 0;
    osDelay(V_SYNC_LEN);
    v_sync = 1;
    
    osMutexWait(h_counter, osWaitForever); // this should take no time, no one else uses this now!
    h_num = 0;
    osMutexRelease(h_counter);
    
    osTimerStart(h_timer, H_SYNC_CYCLE_LEN);
    
    while(1){
        osMutexWait(h_counter, osWaitForever);
        if(h_num >= 480) break;
        osMutexRelease(h_counter);
        osDelay(0.1);
    }
    osTimerStop(h_timer);
}

void h_sync_loop(void const *n){
    osMutexWait(h_counter, osWaitForever);
    if(h_num++ < 480){
        osMutexRelease(h_counter);
        h_sync = 0;
        osDelay(H_SYNC_LEN);
        h_sync = 1;
    }
    else osMutexRelease(h_counter);     
}

osTimerDef(v_sync, v_sync_loop);
osTimerDef(h_sync, h_sync_loop);

int main(void) {
    v_sync = 1;
    h_sync = 1;
    
    v_timer = osTimerCreate(osTimer(v_sync), osTimerPeriodic, (void *)0);
    h_timer = osTimerCreate(osTimer(h_sync), osTimerPeriodic, (void *)0);
    osTimerStart(v_timer, V_SYNC_CYCLE_LEN);
    
    osDelay(osWaitForever);
}
