#include "mbed.h"
#include <string> // this should be already included in <sstream>
#include "TPS92520.h"


TPS92520 LedDriver(PA_7, PA_6, PA_5, PA_4, PA_0);

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);

DigitalOut CH1_PWM(PA_1);
DigitalOut CH2_PWM(PA_3);

volatile char   c = '\0'; // Initialized to the NULL character

void Rx_interrupt();
void read_line();
int hex2int(char ch);

// Circular buffers for serial TX and RX data - used by interrupt routines
const int buffer_size = 255;
// might need to increase buffer size for high baud rates
char rx_buffer[buffer_size+1];
// Circular buffer pointers
// volatile makes read-modify-write atomic 
volatile int rx_in=0;
volatile int rx_out=0;
// Line buffers for sprintf and sscanf
char rx_line[80];

// Receive Buffer 
char buffer[50];
 
int main() {
 
    pc.baud(9600);
    pc.attach(&Rx_interrupt, Serial::RxIrq);
    pc.printf("TPS92520 Test Software\n\r");

    
    // Enable Led Channels
    CH1_PWM = 0;
    CH2_PWM = 0;
    
    
    LedDriver.init();
    LedDriver.reset();
    LedDriver.status();
    
    int ret, pokus;
    char buf[50];    
    
    while(1) {
        
        /* Status read TPS92520 */
        sprintf(buffer, LedDriver.status());
        if(strncmp(buffer, buf, strlen(buffer))) {
            strcpy(buf, buffer);
            pc.printf("Status:\n%s", buf); }
        
        /* Status LED */            
        myled = !myled; 
        wait(0.2); // 200 ms
        
        /* COM PORT read incoming data */
        read_line();
        
    }
}


// Read a line from the large rx buffer from rx interrupt routine
void read_line() {
    int i=0;
    int raw_data = 0;
    int raw_data2 = 0;
    int response, ret, ret2;
    // Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\r')) {
        // Wait if buffer empty
        if (rx_in == rx_out) {
            return;
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
    rx_line[i-1] = 0;
    if(strncmp(rx_line,"W",1)== 0) {
        
        int address = 16*hex2int(rx_line[2])+hex2int(rx_line[3]);
        int data = 16*hex2int(rx_line[5])+hex2int(rx_line[6]);
        
        pc.printf("Writing register: Address: %d\r\n", address);
        pc.printf("Writing register: Data: %d\r\n", data);
        ret = LedDriver.writeRegs(address, data, &response);
        if(ret < 0) printf("Error Code A: %d\r\n", ret);
        pc.printf("Writen Data: %d\r\n", response & 0x00FF);
    }
    else if(strncmp(rx_line,"R",1)== 0) {
        
        int address = 16*hex2int(rx_line[2])+hex2int(rx_line[3]);
        
        pc.printf("Reading register: Address: %d\r\n", address);
        ret = LedDriver.readRegs(address, &raw_data);
        if(ret < 0) printf("Error Code A: %d\r\n", ret);

        pc.printf("Register data: %d\r\n", raw_data & 0x00FF);
    }
    else if(strncmp(rx_line,"reset",5) == 0) {
        ret = LedDriver.reset();
        pc.printf("Reseting device\r\n");
        if(ret < 0) printf("Error Code: %d\r\n", ret); }
    else if(strncmp(rx_line,"stat",4) == 0) {
        pc.printf("%s", LedDriver.status()); }
    else if(strncmp(rx_line,"temp",4) == 0) {
        pc.printf("%s", LedDriver.temp()); }
    else {
        pc.printf("Invalid Command\r\n"); 
    }
    
    return;
}


// Interupt Routine to read in data from serial port
void Rx_interrupt() {
    // Loop just in case more than one character is in UART's receive FIFO buffer
    // Stop if buffer full
    while ((pc.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = pc.getc();
        // Uncomment to Echo to USB serial to watch data flow
        // pc.putc(rx_buffer[rx_in]);
        rx_in = (rx_in + 1) % buffer_size;
    }
    return;
}

int hex2int(char ch)
{
    if (ch >= '0' && ch <= '9')
        return ch - '0';
    if (ch >= 'A' && ch <= 'F')
        return ch - 'A' + 10;
    if (ch >= 'a' && ch <= 'f')
        return ch - 'a' + 10;
    return -1;
}
