/*
############################################
##           Motor Control v0.1 Library   ##
##          created by Peter Ilsoee       ##
############################################
        ---- piniels@gmail.com -----
This library was made for 4-Phase Stepper Motors for A4980 SPI device from Allegro
I don't take any resposability for the damage caused to your equipment.

*/
#ifndef MOTOR_CONTROL_H
#define MOTOR_CONTROL_H

#include "mbed.h"
#include "A4980ControlRegi.h"

class motorControl {
public:

    motorControl(int numberOfSteps, PinName step, PinName dir, PinName ms1, PinName ms0, PinName enable, PinName reset, PinName diag); //motor constructor
    void step(int num_steps, int direction, int speed);

    void initSpi();
    int setConfigRegi0(t_config_control_regi_0 value);
    int setConfigRegi1(t_config_control_regi_1 value);
    int setRunRegi(t_run_regi value);
    int getStepCount();
    void setStepCount(int value);
    void setMicroSteps(int value);
    int getMicroSteps();
    t_config_control_regi_0 getConfigRegi0();
    t_config_control_regi_1 getConfigRegi1();
    t_run_regi getRunRegi();
    void runStepperAtSpeed(bool startStop, int whatSpeed, int direction);
    void runStepperAtSpeedWithSPI(bool startStop, int whatSpeed, int direction);
    void goToZeroPosition(int whatSpeed);
    void openCloseValve(bool openTrue);
    /** Call back member for timer tick
     *
     */
    void runMotor(void);
    void doRamp(int numberOfRampsteps,float endDelay);
    float calculateStepDelay(int whatSpeed);
    void step(int num_steps, int delay, bool direction);
    
private:
    int _Number_OF_STEPS;
    int _Step_Counter;
    bool _Bool_Direction;
    PwmOut _STEP;
    DigitalOut _DIR;
    DigitalOut _MS1;
    DigitalOut _MS0;
    DigitalOut _ENABLE;
    DigitalOut _RESET;
    DigitalIn  _DIAG;
    float step_delay;
    t_config_control_regi_0 _REGI_0;
    t_config_control_regi_1 _REGI_1;
    t_run_regi              _REGI_RUN;
    



};

#endif
