/*-----------------------------------------------------------
*                   COPYRIGHT (C) 2010.
*          GN Otometrics. All rights reserved.
*-----------------------------------------------------------
*            P R O P R I E T A R Y   R I G H T S
* This document must not be used, nor copied in any form or
* handed over to third party, without prior written
* permission from GN Otometrics.
*-----------------------------------------------------------
*
* This source file is part of the 1082 Turtle project.
*
* P4 Info: (P4-filetype must be "ktext" for these to work!)
* Last edit by: $Author:$
* Date:         $DateTime:$
* Filename:     $File:$
* Revision:     $Revision:$
*
* File Info:
* Original author: peilni
* Creation date:   Nov 19, 2013
*
* Doxygen Info: *//*!
* @file
* @brief Blah blah blah.
*
* @htmlonly
* @endhtmlonly
*
* Blah blah
*/
#ifndef A4980CONTROLREGI_H_
#define A4980CONTROLREGI_H_
#include <stdint.h>

/*
 * (*) are default
 */
typedef union
{
    uint16_t I;

    struct
    {
        uint16_t pwm              : 1;    // bit0 PWM configuration *0=Fixed off-time, 1=Fixed frequency
        uint16_t tofFrq           : 3;    // bit3-1 Off time (only valid when PWM bit = 0).Replaces FRQ bits(Assumes 4-MHz clock) 000=20us, 001=24us, 010=28us, 011=32us, 100=36us, 101=40us, *110=44us, 111=48us//        Frequency )(only valid when PWM bit = 1)Replace TOF bits(Assumes 4-MHz clock) 000=24us/41.7kHz, 001=32us/31.3kHz, 010=40us/25kHz, 011=46us/21.7kHz, 100=52us/19.2kHz 101=56us/17.9kHz, *110=60us/16.7kHz, 111=64us/15.6kHz
        uint16_t tbk              : 2;    // bit5-4 Blank Time (Assumes 4-MHz clock) 00=1us, *01=1.5us, 10=2.5us, 11=3.5us
        uint16_t pfd              : 3;    // bit8-6 Fast decay time for mixed decay. Assumes 4-MHz clock 000=2us, 001=3us, 010=4us, 011=6us, 100=8us, 101=10us, 110=14us, 111=20us
        uint16_t mx               : 2;    // bit10-9. Max phase current as a percentage of I(SMAX) 00=25% 01=50% 10=75% *11=100%
        uint16_t ms               : 2;    // bit12-11. Microstep mode for external STEP input control *00=Full Step 01=Half Step 10=Quarter Step 11=Sixteenth Step
        uint16_t syr              : 1;    // bit13. Synchronous rectification 0=Diode recirculation *1=Synchronous
        uint16_t addr             : 2;    // bit15-14 Address config0 = 0b00

    } B;
} t_config_control_regi_0;

/*
 * (*) are default
 */
typedef union
{
    uint16_t I;

    struct
    {
        uint16_t diag             : 2;    // bit1-0 Selects signal routed to DIAG output *00=Fault-low true, 01=ST-low true, 10=PWN-on Phase A, 11=Temperature
        uint16_t cd               : 4;    // bit5-2 PWM count difference for ST detection default to 8
        uint16_t notInUse         : 5;    // bit10-6 Not in use value = 0
        uint16_t tsc              : 2;    // bit12-11 Overcurrent fault delay(Assumes 4-MHz clock) 00=0.5us, 01=1us, *10=2us, 11=3us
        uint16_t osc              : 1;    // bit13 Selects clock source *0=internal, 1=external
        uint16_t addr             : 2;    // bit15-14 Address config0 = 0b01

    } B;
}t_config_control_regi_1;

/*
 * (*) are default
 */
typedef union
{
    uint16_t I;

    struct
    {
        uint16_t sc               : 6;    // bit5-0 Step change number 2’s complement format. Positive value increases Step Angle Number. Negative value decreases Step Angle Number
        uint16_t dcy              : 2;    // bit7-6 Decay mode selection 00=Slow, *01=Mixed-PFD fixed, 10=Mixed-PFD auto, 11=Fast
        uint16_t brk              : 1;    // bit8 Brake enable *0=Normal operation 1=Brake active
        uint16_t slew             : 1;    // bit9 Slew rate control 0=Disable *1=Enable
        uint16_t hlr              : 1;    // bit10. Selects slow decay and brake recirculation path *0=High side, 1=Low side
        uint16_t ol               : 2;    // bit12-11. Open load current threshold as a percentage of maximum current defined by ISMAX and MXI[1..0] 00=20%, *01=30%, 10=40%, 11=50%
        uint16_t en               : 1;    // bit13. Phase current enable OR with ENABLE pin *0=Output bridges disabled if ENABLE pin = 0, 1=Output bridges enabled
        uint16_t addr             : 2;    // bit15-14 Address run = 0b10

    } B;
}t_run_regi;



#endif /* A4980CONTROLREGI_H_ */
