/*
###############################################################
##           Board Mount Humidity Sensors I2C v0.1 Library   ##
##          created by Peter Ilsoee                          ##
###############################################################
        ---- piniels@gmail.com -----
This library was made for the HIH6130-021 Board Mount Humidity Sensors I2C
I don't take any resposability for the damage caused to your equipment.

*/

#include "HIH_6130.h"
#include "mbed.h"

I2C i2c(PTC11,PTC10); //remember to change this to fit our HW

/**
 * ! @brief Construct including the pins for I2c connection for the sensor
 * @param sda Serial data pin
 * @param scl Serial cloack pin
 * 
 */
hih6130::hih6130(PinName sda, PinName scl):_SDA(sda),_SCL(scl) {



}

/**
 * ! @brief Initialize the I2C connection
 * @return the I2C object
 * 
 */
void hih6130::initI2C()
{
    i2c.frequency(i2cFreq);
}

int hih6130::measurementRequest()
{
    int returnValue;
    i2c.start();
    i2c.write(addr);
    i2c.stop();
    wait(0.04);
    i2c.start();
    returnValue = i2c.read(addr, cmd, 4);
    i2c.stop();
    return returnValue;
}

float hih6130::readHumidity()
{
    float humiRH;
    measurementRequest();
    if((cmd[0] & 0xc0) == 0) //Check if data is valid see data sheet for sensor
    {
        float humiRaw = ((cmd[0] & 0x3f) << 8) | (cmd[1] & 0xff); //converting the bytes to a float
        humiRH = (humiRaw/16382)*100; //see data sheet
    }
    else
    {
        humiRH = 0;
    }
    
    return humiRH;
     

}

float hih6130::readTemperature()
{
    float temperature;
    measurementRequest();
    if((cmd[0] & 0xc0) == 0) //Check if data is valid see data sheet for sensor
    {
        float tempRaw = ( ((int)cmd[2] << 8) | cmd[3] ) >> 2 ; //converting the bytes to a float
        temperature = ((tempRaw/16382)*165) - 40; //see data sheet
    }
    else
    {
        temperature = 0;
    }
    
    return temperature;
}


int hih6130::fetchDataRaw()
{
    int returnInt;
    measurementRequest();
    
    returnInt = (int)((cmd[0] << 24) | (cmd[1] << 16) | (cmd[2] << 8) | cmd[3]);
    return returnInt;
}
