#include "mbed.h"

// MaxSonar EZ1 test program
// by Michael Shimniok http://www.bot-thoughts.com/
//
// Based on datasheet here: http://www.maxbotix.com/uploads/LV-MaxSonar-EZ1-Datasheet.pdf
// Reads from AN (analog) pin connected to mbed p20, assumes 3.3V supply to EZ1 module.
//
// mbed -> EZ1
// -----------
// VOUT -> +5
// GND  -> GND
// p20  -> AN
//

AnalogIn ain(p20);
Serial pc(USBTX, USBRX); // tx, rx

int main() {
    float adc, volts, cent;
    
    pc.baud(9600);
    
    while (1){
        adc = ain.read();           // read analog as a float
        volts = adc * 3.3;          // convert to volts
        cent = volts / 0.0032;    // 3.3V supply: 3.2mV per centimeter
        
        pc.printf("%f adc - %f cent \n", adc, cent);
        wait(2);                 // 20Hz update rate ; note we aren't truly synchronized to the device or anything...   
    }
}


